/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.tasks.kafka;

import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.kafka.KafkaProducerPool;
import com.dtstep.lighthouse.core.tasks.EventSender;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaEventSender
implements EventSender {
    private static final Logger logger = LoggerFactory.getLogger(KafkaEventSender.class);
    private static final KafkaProducerPool producerPool = new KafkaProducerPool();
    private static final String KAFKA_TOPIC_NAME = LDPConfig.getVal("kafka.topic.name");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String text) throws Exception {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        KafkaProducer<byte[], byte[]> producer = producerPool.getInstance();
        try {
            producer.send(new ProducerRecord(KAFKA_TOPIC_NAME, (Object)RandomID.id((int)15).getBytes(StandardCharsets.UTF_8), (Object)text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception ex) {
            logger.error("send message failed!", (Throwable)ex);
        }
        finally {
            producerPool.release(producer);
        }
    }

    @Override
    @Deprecated
    public void syncSend(String text) throws Exception {
        KafkaProducer<byte[], byte[]> producer = producerPool.getInstance();
        producer.send(new ProducerRecord(KAFKA_TOPIC_NAME, (Object)RandomID.id((int)15).getBytes(StandardCharsets.UTF_8), (Object)text.getBytes(StandardCharsets.UTF_8)), (recordMetadata, ex) -> {
            if (ex != null) {
                logger.error("send message failed!", (Throwable)ex);
            }
        }).get();
        producerPool.release(producer);
    }
}

