/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.tasks.standalone;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.consumer.RealTimeProcessor;
import com.dtstep.lighthouse.core.preparing.handler.expand.ExpandEvent;
import com.dtstep.lighthouse.core.preparing.pipe.Pipeline;
import com.dtstep.lighthouse.core.preparing.pipe.PipelineBuilder;
import com.dtstep.lighthouse.core.preparing.pipe.stage.ExpandStageImpl;
import com.dtstep.lighthouse.core.preparing.pipe.stage.TranslateStageImpl;
import com.dtstep.lighthouse.core.preparing.pipe.stage.ValidStageImpl;
import com.dtstep.lighthouse.core.tasks.EventSender;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneEventSender
implements EventSender {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneEventSender.class);
    private static final Pipeline<byte[], ExpandEvent> pipeline;

    @Override
    public void send(String text) throws Exception {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        try {
            List<ExpandEvent> expandEventList = pipeline.process(text.getBytes(StandardCharsets.UTF_8));
            if (CollectionUtils.isNotEmpty(expandEventList)) {
                for (ExpandEvent expandEvent : expandEventList) {
                    RealTimeProcessor.onEvent(expandEvent);
                }
            }
        }
        catch (Exception ex) {
            logger.error("send message failed!", (Throwable)ex);
        }
    }

    @Override
    public void syncSend(String text) throws Exception {
    }

    static {
        TranslateStageImpl translateStage = new TranslateStageImpl();
        ValidStageImpl validStage = new ValidStageImpl();
        ExpandStageImpl expandStage = new ExpandStageImpl();
        pipeline = PipelineBuilder.create(translateStage).add(validStage).add(expandStage).build();
    }
}

