/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.tools;

import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.storage.warehouse.hbase.HBaseWarehouseStorageEngine;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTableRegionMerge {
    private static final Logger logger = LoggerFactory.getLogger(HBaseTableRegionMerge.class);

    public static void main(String[] args) throws Exception {
        HBaseWarehouseStorageEngine storageEngine;
        TableName[] tableNames;
        LDPConfig.loadConfiguration();
        int targetSize = 6;
        if (args != null) {
            targetSize = Integer.parseInt(args[0]);
        }
        if ((tableNames = (storageEngine = new HBaseWarehouseStorageEngine()).listTables()) == null || tableNames.length == 0) {
            return;
        }
        for (TableName tableName : tableNames) {
            String tableNameStr = tableName.getNameAsString();
            storageEngine.merge(tableNameStr, targetSize);
            Thread.sleep(10000L);
            List<RegionInfo> regionInfoList = storageEngine.getRegionInfo(tableNameStr);
            if (regionInfoList.size() == targetSize) continue;
            logger.error("Merge table failed,tableName:{},current region size:{},target region size:{}", new Object[]{tableNameStr, regionInfoList.size(), targetSize});
            break;
        }
        logger.info("Execution completed and the program exits!");
        System.exit(0);
    }
}

