/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.tools;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;

public class TimePeriodUtil {
    private static final ZoneId ZONE = ZoneId.systemDefault();
    private static final long SECOND_MS = 1000L;
    private static final long MINUTE_MS = 60000L;
    private static final long HOUR_MS = 3600000L;
    private static final long DAY_MS = 86400000L;

    public static long[] resolvePeriod(String period) {
        Objects.requireNonNull(period, "period\u4e0d\u80fd\u4e3a\u7a7a");
        period = period.trim();
        long now = System.currentTimeMillis();
        ZonedDateTime nowZdt = Instant.ofEpochMilli(now).atZone(ZONE);
        LocalDate today = nowZdt.toLocalDate();
        if (period.contains("-")) {
            String[] parts = period.split("-", 2);
            long start = TimePeriodUtil.getStart(parts[0], now, today);
            long end = TimePeriodUtil.getStart(parts[1], now, today);
            return new long[]{start, end};
        }
        return new long[]{TimePeriodUtil.getStart(period, now, today), TimePeriodUtil.getEnd(period, now, today)};
    }

    private static long getStart(String expr, long now, LocalDate today) {
        Parsed p = TimePeriodUtil.parse(expr);
        return p.type == Type.LAST ? TimePeriodUtil.calcLastStart(p, now, today) : TimePeriodUtil.calcPrevStart(p, now, today);
    }

    private static long getEnd(String expr, long now, LocalDate today) {
        Parsed p = TimePeriodUtil.parse(expr);
        return p.type == Type.LAST ? TimePeriodUtil.calcLastEnd(p, now, today) : TimePeriodUtil.calcPrevEnd(p, now, today);
    }

    private static Parsed parse(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr null");
        }
        Parsed p = new Parsed();
        if (expr.startsWith("last")) {
            p.type = Type.LAST;
        } else if (expr.startsWith("prev")) {
            p.type = Type.PREV;
        } else {
            throw new IllegalArgumentException("expr must start with last or prev: " + expr);
        }
        int i = 4;
        int num = 0;
        boolean hasNum = false;
        while (i < expr.length() && Character.isDigit(expr.charAt(i))) {
            num = num * 10 + (expr.charAt(i++) - 48);
            hasNum = true;
        }
        if (!hasNum || i >= expr.length()) {
            throw new IllegalArgumentException("invalid expr: " + expr);
        }
        p.num = num;
        p.unit = expr.charAt(i);
        return p;
    }

    private static long calcLastStart(Parsed p, long nowMillis, LocalDate today) {
        switch (p.unit) {
            case 's': {
                return nowMillis - (long)p.num * 1000L;
            }
            case 'm': {
                return nowMillis - (long)p.num * 60000L;
            }
            case 'h': {
                return nowMillis - (long)p.num * 3600000L;
            }
            case 'd': {
                return p.num == 0 ? today.atStartOfDay(ZONE).toInstant().toEpochMilli() : today.minusDays(p.num).atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
            case 'w': {
                LocalDate weekStart = today.minusWeeks(p.num).with(DayOfWeek.MONDAY);
                return weekStart.atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
            case 'M': {
                LocalDate monthStart = today.minusMonths(p.num).withDayOfMonth(1);
                return monthStart.atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
        }
        throw new IllegalArgumentException("unsupported unit: " + p.unit);
    }

    private static long calcLastEnd(Parsed p, long nowMillis, LocalDate today) {
        if (p.unit == 'd') {
            return today.atTime(23, 59, 59, 999000000).atZone(ZONE).toInstant().toEpochMilli();
        }
        if (p.unit == 'w' && p.num >= 1) {
            LocalDate thisWeekEnd = today.with(DayOfWeek.SUNDAY);
            return thisWeekEnd.atTime(23, 59, 59, 999000000).atZone(ZONE).toInstant().toEpochMilli();
        }
        if (p.unit == 'M' && p.num >= 1) {
            LocalDate thisMonthLast = today.with(TemporalAdjusters.lastDayOfMonth());
            return thisMonthLast.atTime(23, 59, 59, 999000000).atZone(ZONE).toInstant().toEpochMilli();
        }
        return nowMillis;
    }

    private static long calcPrevStart(Parsed p, long now, LocalDate today) {
        switch (p.unit) {
            case 's': {
                return now / 1000L * 1000L - (long)p.num * 1000L;
            }
            case 'm': {
                return now / 60000L * 60000L - (long)p.num * 60000L;
            }
            case 'h': {
                return now / 3600000L * 3600000L - (long)p.num * 3600000L;
            }
            case 'd': {
                return today.minusDays(p.num).atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
            case 'w': {
                return today.minusWeeks(p.num).with(DayOfWeek.MONDAY).atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
            case 'M': {
                return today.minusMonths(p.num).withDayOfMonth(1).atStartOfDay(ZONE).toInstant().toEpochMilli();
            }
        }
        throw new IllegalArgumentException("unsupported unit: " + p.unit);
    }

    private static long calcPrevEnd(Parsed p, long now, LocalDate today) {
        switch (p.unit) {
            case 's': {
                return now / 1000L * 1000L - (long)(p.num - 1) * 1000L - 1L;
            }
            case 'm': {
                return now / 60000L * 60000L - (long)(p.num - 1) * 60000L - 1L;
            }
            case 'h': {
                return now / 3600000L * 3600000L - (long)(p.num - 1) * 3600000L - 1L;
            }
            case 'd': {
                return today.minusDays(p.num).atTime(23, 59, 59, 999000000).atZone(ZONE).toInstant().toEpochMilli();
            }
            case 'w': {
                LocalDate ws = today.minusWeeks(p.num).with(DayOfWeek.MONDAY);
                LocalDate we = ws.with(DayOfWeek.SUNDAY);
                return we.atTime(23, 59, 59).atZone(ZONE).toInstant().toEpochMilli();
            }
            case 'M': {
                LocalDate m1 = today.minusMonths(p.num).withDayOfMonth(1);
                LocalDate mEnd = m1.with(TemporalAdjusters.lastDayOfMonth());
                return mEnd.atTime(23, 59, 59, 999000000).atZone(ZONE).toInstant().toEpochMilli();
            }
        }
        throw new IllegalArgumentException("unsupported unit: " + p.unit);
    }

    private static class Parsed {
        Type type;
        int num;
        char unit;

        private Parsed() {
        }
    }

    private static enum Type {
        LAST,
        PREV;

    }
}

