/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.tools;

import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.util.DateUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimePointUtil {
    private static final Pattern BATCH_NUMBER = Pattern.compile("t-(\\d+)");
    private static final Pattern BATCH_MINUTE = Pattern.compile("t-(\\d+)m");
    private static final Pattern BATCH_HOUR = Pattern.compile("t-(\\d+)h");
    private static final Pattern BATCH_DAY = Pattern.compile("t-(\\d+)d");
    private static final Pattern BATCH_MONTH = Pattern.compile("t-(\\d+)M");
    private static final Pattern BATCH_YEAR = Pattern.compile("t-(\\d+)y");

    public static Long getBatchTime(StatExtEntity statExtEntity, long currentTime, String batch) throws Exception {
        if (statExtEntity == null) {
            return 999999999999999997L;
        }
        if (batch == null || batch.isEmpty()) {
            return 999999999999999997L;
        }
        ZoneId zone = ZoneId.systemDefault();
        ZonedDateTime now = Instant.ofEpochMilli(currentTime).atZone(zone);
        Matcher matcher = BATCH_MINUTE.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            ZonedDateTime target = now.minusMinutes(diff);
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)target.toInstant().toEpochMilli());
        }
        matcher = BATCH_HOUR.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            ZonedDateTime target = now.minusHours(diff);
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)target.toInstant().toEpochMilli());
        }
        matcher = BATCH_DAY.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            ZonedDateTime target = now.minusDays(diff);
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)target.toInstant().toEpochMilli());
        }
        matcher = BATCH_MONTH.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            ZonedDateTime target = now.minusMonths(diff);
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)target.toInstant().toEpochMilli());
        }
        matcher = BATCH_YEAR.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            ZonedDateTime target = now.minusYears(diff);
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)target.toInstant().toEpochMilli());
        }
        matcher = BATCH_NUMBER.matcher(batch);
        if (matcher.matches()) {
            int diff = Integer.parseInt(matcher.group(1));
            long interval = statExtEntity.getTimeUnit().toMillis(statExtEntity.getTimeParamInterval());
            long timeStamp = currentTime - (long)diff * interval;
            return DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)timeStamp);
        }
        return 999999999999999997L;
    }
}

