/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.enums.CallerStateEnum;
import com.dtstep.lighthouse.common.modal.Caller;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerDBWrapper {
    private static final Logger logger = LoggerFactory.getLogger(CallerDBWrapper.class);
    private static final Integer _CacheExpireMinutes = 5;
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Cache<Object, Optional<Caller>> CALLER_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();

    public static Caller queryByName(String callerName) {
        Optional optional = (Optional)CALLER_CACHE.get((Object)callerName, k -> CallerDBWrapper.actualQueryByName(callerName));
        assert (optional != null);
        return optional.orElse(null);
    }

    private static Optional<Caller> actualQueryByName(String callerName) {
        Caller caller = null;
        try {
            caller = CallerDBWrapper.queryCallerByNameFromDB(callerName);
        }
        catch (Exception ex) {
            logger.error("query caller info error!", (Throwable)ex);
        }
        return Optional.ofNullable(caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Caller queryCallerByNameFromDB(String callerName) throws Exception {
        Caller caller;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            caller = (Caller)queryRunner.query(conn, String.format("select id,name,state,secret_key,create_time,update_time from ldp_callers where name = '%s'", callerName), (ResultSetHandler)new CallerSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return caller;
    }

    private static class CallerSetHandler
    implements ResultSetHandler<Caller> {
        private CallerSetHandler() {
        }

        public Caller handle(ResultSet rs) throws SQLException {
            Caller caller = null;
            if (rs.next()) {
                caller = new Caller();
                int id = rs.getInt("id");
                String name = rs.getString("name");
                int state = rs.getInt("state");
                String secretKey = rs.getString("secret_key");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                caller.setId(Integer.valueOf(id));
                caller.setName(name);
                caller.setState(CallerStateEnum.forValue((int)state));
                caller.setSecretKey(secretKey);
                caller.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                caller.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
            }
            return caller;
        }
    }
}

