/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.stat.TimeParam;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.modal.DebugParam;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.GroupExtendConfig;
import com.dtstep.lighthouse.common.modal.LimitingParam;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.CalculateUtil;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.formula.FormulaTranslate;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.template.TemplateContext;
import com.dtstep.lighthouse.core.template.TemplateParser;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupDBWrapper {
    private static final Logger logger = LoggerFactory.getLogger(GroupDBWrapper.class);
    private static final Integer _CacheExpireMinutes = 3;
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Cache<Object, Optional<GroupExtEntity>> groupCache = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(500000L).softValues().build();

    public static GroupExtEntity queryByToken(String token) {
        Optional optional = (Optional)groupCache.get((Object)token, k -> GroupDBWrapper.actualQueryGroupByToken(token));
        assert (optional != null);
        return optional.orElse(null);
    }

    public static GroupExtEntity queryById(int groupId) {
        Optional optional = (Optional)groupCache.get((Object)groupId, k -> GroupDBWrapper.actualQueryGroupById(groupId));
        assert (optional != null);
        return optional.orElse(null);
    }

    public static Optional<GroupExtEntity> actualQueryGroupByToken(String token) {
        if (BuiltinLoader.isBuiltinGroup(token)) {
            return Optional.ofNullable(BuiltinLoader.getBuiltinGroup(token));
        }
        GroupExtEntity groupExtEntity = null;
        try {
            Group groupEntity = GroupDBWrapper.queryGroupByTokenFromDB(token);
            if (groupEntity != null) {
                groupExtEntity = GroupDBWrapper.combineExtInfo(groupEntity);
            }
            return Optional.ofNullable(groupExtEntity);
        }
        catch (Exception ex) {
            logger.error("query group info error!", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static Optional<GroupExtEntity> actualQueryGroupById(int groupId) {
        if (BuiltinLoader.isBuiltinGroup(groupId)) {
            return Optional.ofNullable(BuiltinLoader.getBuiltinGroup(groupId));
        }
        GroupExtEntity groupExtEntity = null;
        try {
            Group groupEntity = GroupDBWrapper.queryGroupByIdFromDB(groupId);
            if (groupEntity != null) {
                groupExtEntity = GroupDBWrapper.combineExtInfo(groupEntity);
            }
            return Optional.ofNullable(groupExtEntity);
        }
        catch (Exception ex) {
            logger.error("query group info error!", (Throwable)ex);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Group queryGroupByIdFromDB(int groupId) throws Exception {
        Group group;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            group = (Group)queryRunner.query(conn, String.format("select * from ldp_groups where id = '%s'", groupId), (ResultSetHandler)new GroupResultSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Group queryGroupByTokenFromDB(String token) throws Exception {
        Group group;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            group = (Group)queryRunner.query(conn, String.format("select * from ldp_groups where token = '%s'", token), (ResultSetHandler)new GroupResultSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int changeState(int groupId, GroupStateEnum groupStateEnum, LocalDateTime date) throws Exception {
        int result;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            if (groupStateEnum == GroupStateEnum.LIMITING) {
                long startTime = DateUtil.translateToTimeStamp((LocalDateTime)date);
                long endTime = DateUtil.getMinuteAfter((long)startTime, (int)15);
                LimitingParam limitingParam = new LimitingParam();
                limitingParam.setStartTime(startTime);
                limitingParam.setEndTime(endTime);
                result = queryRunner.update(conn, "update ldp_groups set state = ?,refresh_time = ?,limiting_param =? where id = ? and state = ?", new Object[]{groupStateEnum.getState(), date, JsonUtil.toJSONString((Object)limitingParam), groupId, GroupStateEnum.RUNNING.getState()});
            } else {
                result = queryRunner.update(conn, "update ldp_groups set state = ?,refresh_time = ? where id = ?", new Object[]{groupStateEnum.getState(), date, groupId});
            }
        }
        finally {
            storageEngine.closeConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int changeDebugMode(int groupId, SwitchStateEnum switchStateEnum, LocalDateTime date) throws Exception {
        int result;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            if (switchStateEnum == SwitchStateEnum.OPEN) {
                long startTime = DateUtil.translateToTimeStamp((LocalDateTime)date);
                long endTime = DateUtil.getMinuteAfter((long)startTime, (int)15);
                DebugParam debugParam = new DebugParam();
                debugParam.setStartTime(startTime);
                debugParam.setEndTime(endTime);
                result = queryRunner.update(conn, "update ldp_groups set debug_mode = ?,refresh_time = ?,debug_param =? where id = ? and debug_mode = ?", new Object[]{switchStateEnum.getState(), date, JsonUtil.toJSONString((Object)debugParam), groupId, SwitchStateEnum.CLOSE.getState()});
            } else {
                result = queryRunner.update(conn, "update ldp_groups set debug_mode = ?,refresh_time = ? where id = ? and debug_mode = ?", new Object[]{switchStateEnum.getState(), date, groupId, SwitchStateEnum.OPEN.getState()});
            }
        }
        finally {
            storageEngine.closeConnection();
        }
        return result;
    }

    public static GroupExtEntity combineExtInfo(Group groupEntity) throws Exception {
        GroupExtendConfig groupExtendConfig;
        HashMap limitingMap;
        GroupExtEntity groupExtEntity = new GroupExtEntity(groupEntity);
        if (GroupExtEntity.isLimitedExpired((GroupExtEntity)groupExtEntity)) {
            GroupDBWrapper.changeState(groupEntity.getId(), GroupStateEnum.RUNNING, LocalDateTime.now());
            groupExtEntity.setState(GroupStateEnum.RUNNING);
        }
        if (GroupExtEntity.isDebugModeExpired((GroupExtEntity)groupExtEntity)) {
            GroupDBWrapper.changeDebugMode(groupEntity.getId(), SwitchStateEnum.CLOSE, LocalDateTime.now());
            groupExtEntity.setDebugMode(SwitchStateEnum.CLOSE);
        }
        List columnList = groupEntity.getColumns();
        int groupId = groupExtEntity.getId();
        List<Stat> statList = StatDBWrapper.queryStatByGroupIDFromDB(groupId);
        if (CollectionUtils.isNotEmpty(statList)) {
            HashMap<String, ColumnTypeEnum> groupRunningRelatedColumns = new HashMap<String, ColumnTypeEnum>();
            HashMap<String, ColumnTypeEnum> groupAllRelatedColumns = new HashMap<String, ColumnTypeEnum>();
            Map<String, ColumnTypeEnum> groupColumnsMap = columnList.stream().collect(Collectors.toMap(Column::getName, Column::getType));
            long minDuration = 0L;
            long maxDataExpire = 0L;
            for (Stat stat : statList) {
                String template = stat.getTemplate();
                List<Column> statRelatedColumns = FormulaTranslate.queryRelatedColumns(columnList, template);
                ServiceResult<TemplateEntity> serviceResult = TemplateParser.parseConfig(new TemplateContext(stat.getId(), template, stat.getTimeparam(), columnList));
                if (!serviceResult.isSuccess()) {
                    logger.error("load stat error,id:{},template:{}.", (Object)stat.getId(), (Object)template);
                    continue;
                }
                String dimens = ((TemplateEntity)serviceResult.getData()).getDimens();
                List<Column> dimensRelatedColumns = null;
                if (!StringUtil.isEmpty((String)dimens)) {
                    dimensRelatedColumns = FormulaTranslate.queryRelatedColumns(columnList, dimens);
                }
                if (stat.getState() == StatStateEnum.RUNNING || stat.getState() == StatStateEnum.LIMITING) {
                    long currentDuration = TimeParam.calculateDuration((String)stat.getTimeparam());
                    minDuration = minDuration == 0L ? currentDuration : CalculateUtil.getMaxDivisor((long)minDuration, (long)currentDuration);
                    if (maxDataExpire < stat.getExpired()) {
                        maxDataExpire = stat.getExpired();
                    }
                    if (CollectionUtils.isNotEmpty(statRelatedColumns)) {
                        for (Column column : statRelatedColumns) {
                            groupRunningRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                            groupAllRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(dimensRelatedColumns)) continue;
                    for (Column column : dimensRelatedColumns) {
                        groupRunningRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                        groupAllRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                    }
                    continue;
                }
                if (CollectionUtils.isNotEmpty(statRelatedColumns)) {
                    for (Column column : statRelatedColumns) {
                        groupAllRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                    }
                }
                if (!CollectionUtils.isNotEmpty(dimensRelatedColumns)) continue;
                for (Column column : dimensRelatedColumns) {
                    groupAllRelatedColumns.put(column.getName(), groupColumnsMap.get(column.getName()));
                }
            }
            groupExtEntity.setAllRelatedColumns(groupAllRelatedColumns);
            groupExtEntity.setRunningRelatedColumns(groupRunningRelatedColumns);
            TimeParam minTimeParam = GroupDBWrapper.transToTimeParam(minDuration);
            groupExtEntity.setMinTimeParam(minTimeParam);
            groupExtEntity.setDataExpire(maxDataExpire);
        }
        if (StringUtil.isNotEmpty((String)groupExtEntity.getSecretKey())) {
            groupExtEntity.setVerifyKey(Md5Util.getMD5((String)groupExtEntity.getSecretKey()));
        }
        if (!(limitingMap = (groupExtendConfig = groupExtEntity.getExtendConfig()).getLimitingConfig()).containsKey(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING)) {
            int limit = LDPConfig.getOrDefault("limiting.group.message.size.per.sec", -1, Integer.class);
            limitingMap.put(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING, limit);
        }
        if (!limitingMap.containsKey(LimitingStrategyEnum.STAT_RESULT_SIZE_LIMITING)) {
            int limit = LDPConfig.getOrDefault("limiting.stat.result.size.per.sec", -1, Integer.class);
            limitingMap.put(LimitingStrategyEnum.STAT_RESULT_SIZE_LIMITING, limit);
        }
        return groupExtEntity;
    }

    private static TimeParam transToTimeParam(long duration) throws Exception {
        TimeParam timeParam;
        if (duration % TimeUnit.DAYS.toMillis(1L) == 0L) {
            timeParam = new TimeParam((int)(duration / TimeUnit.DAYS.toMillis(1L)), TimeUnit.DAYS);
        } else if (duration % TimeUnit.HOURS.toMillis(1L) == 0L) {
            timeParam = new TimeParam((int)(duration / TimeUnit.HOURS.toMillis(1L)), TimeUnit.HOURS);
        } else if (duration % TimeUnit.MINUTES.toMillis(1L) == 0L) {
            timeParam = new TimeParam((int)(duration / TimeUnit.MINUTES.toMillis(1L)), TimeUnit.MINUTES);
        } else if (duration % TimeUnit.SECONDS.toMillis(1L) == 0L) {
            timeParam = new TimeParam((int)(duration / TimeUnit.SECONDS.toMillis(1L)), TimeUnit.SECONDS);
        } else {
            throw new Exception();
        }
        return timeParam;
    }

    public static GroupStateEnum getState(int groupId) throws Exception {
        boolean isLimited;
        Group groupEntity = GroupDBWrapper.queryGroupByIdFromDB(groupId);
        if (groupEntity == null) {
            return null;
        }
        boolean bl = isLimited = groupEntity.getState() == GroupStateEnum.LIMITING && System.currentTimeMillis() - groupEntity.getRefreshTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() < TimeUnit.MINUTES.toMillis(15L);
        if (isLimited) {
            return GroupStateEnum.LIMITING;
        }
        if (groupEntity.getState() == GroupStateEnum.LIMITING) {
            return GroupStateEnum.RUNNING;
        }
        return groupEntity.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RefreshEntity> queryRefreshIdList() throws Exception {
        List ids;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            long time = DateUtil.getMinuteBefore((long)System.currentTimeMillis(), (int)_CacheExpireMinutes);
            ids = (List)queryRunner.query(conn, "select id,token,refresh_time from ldp_groups where create_time != refresh_time and refresh_time >= ? limit 10000", (ResultSetHandler)new RefreshListSetHandler(), new Object[]{new Date(time)});
        }
        finally {
            storageEngine.closeConnection();
        }
        return ids;
    }

    static {
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("group-cache-refresh-schedule-pool-%d").daemon(true).build());
        service.scheduleWithFixedDelay(new RefreshThread(), 0L, 20L, TimeUnit.SECONDS);
    }

    static class RefreshThread
    implements Runnable {
        RefreshThread() {
        }

        @Override
        public void run() {
            try {
                List<RefreshEntity> entities = GroupDBWrapper.queryRefreshIdList();
                if (CollectionUtils.isNotEmpty(entities)) {
                    for (RefreshEntity refreshEntity : entities) {
                        Optional cacheByToken;
                        Optional cacheById = (Optional)groupCache.getIfPresent((Object)refreshEntity.getId());
                        if (cacheById != null && ((GroupExtEntity)cacheById.get()).getRefreshTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() < refreshEntity.getRefreshTime()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("clear group local cache,id:{},token:{}", (Object)refreshEntity.getId(), (Object)refreshEntity.getToken());
                            }
                            groupCache.invalidate((Object)refreshEntity.getId());
                            groupCache.invalidate((Object)refreshEntity.getToken());
                        }
                        if ((cacheByToken = (Optional)groupCache.getIfPresent((Object)refreshEntity.getToken())) == null || ((GroupExtEntity)cacheByToken.get()).getRefreshTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() >= refreshEntity.getRefreshTime()) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("clear group local cache,id:{},token:{}", (Object)refreshEntity.getId(), (Object)refreshEntity.getToken());
                        }
                        groupCache.invalidate((Object)refreshEntity.getId());
                        groupCache.invalidate((Object)refreshEntity.getToken());
                    }
                }
            }
            catch (Exception ex) {
                logger.error("statistic group cache refresh error!", (Throwable)ex);
            }
        }
    }

    private static class RefreshEntity {
        private Integer id;
        private String token;
        private Long refreshTime;

        public RefreshEntity(Integer id, String token, Long refreshTime) {
            this.id = id;
            this.token = token;
            this.refreshTime = refreshTime;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Long getRefreshTime() {
            return this.refreshTime;
        }

        public void setRefreshTime(Long refreshTime) {
            this.refreshTime = refreshTime;
        }
    }

    private static class RefreshListSetHandler
    implements ResultSetHandler<List<RefreshEntity>> {
        private RefreshListSetHandler() {
        }

        public List<RefreshEntity> handle(ResultSet resultSet) throws SQLException {
            ArrayList<RefreshEntity> list = new ArrayList<RefreshEntity>();
            while (resultSet.next()) {
                Integer id = resultSet.getInt("id");
                String token = resultSet.getString("token");
                long refreshTime = resultSet.getTimestamp("refresh_time").getTime();
                list.add(new RefreshEntity(id, token, refreshTime));
            }
            return list;
        }
    }

    private static class GroupResultSetHandler
    implements ResultSetHandler<Group> {
        private GroupResultSetHandler() {
        }

        public Group handle(ResultSet rs) throws SQLException {
            Group group = null;
            if (rs.next()) {
                String debugParam;
                String limitingParam;
                group = new Group();
                Integer id = rs.getInt("id");
                String token = rs.getString("token");
                Integer projectId = rs.getInt("project_id");
                int debugMode = rs.getInt("debug_mode");
                String columns = rs.getString("columns");
                Integer dataVersion = rs.getInt("data_version");
                String randomId = rs.getString("random_id");
                String desc = rs.getString("desc");
                String extendConfig = rs.getString("extend_config");
                if (StringUtil.isNotEmpty((String)extendConfig)) {
                    GroupExtendConfig groupExtendConfig = (GroupExtendConfig)JsonUtil.toJavaObject((String)extendConfig, GroupExtendConfig.class);
                    group.setExtendConfig(groupExtendConfig);
                }
                if (StringUtil.isNotEmpty((String)(limitingParam = rs.getString("limiting_param")))) {
                    LimitingParam groupLimitingParam = (LimitingParam)JsonUtil.toJavaObject((String)limitingParam, LimitingParam.class);
                    group.setLimitingParam(groupLimitingParam);
                }
                if (StringUtil.isNotEmpty((String)(debugParam = rs.getString("debug_param")))) {
                    DebugParam groupDebugParam = (DebugParam)JsonUtil.toJavaObject((String)debugParam, DebugParam.class);
                    group.setDebugParam(groupDebugParam);
                }
                String secretKey = rs.getString("secret_key");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                int state = rs.getInt("state");
                long refreshTime = rs.getTimestamp("refresh_time").getTime();
                group.setId(id);
                group.setToken(token);
                group.setProjectId(projectId);
                SwitchStateEnum debugModeState = SwitchStateEnum.forValue((int)debugMode);
                group.setDebugMode(debugModeState);
                group.setDesc(desc);
                group.setDataVersion(dataVersion);
                group.setSecretKey(secretKey);
                group.setRandomId(randomId);
                group.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                group.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
                group.setRefreshTime(DateUtil.timestampToLocalDateTime((long)refreshTime));
                GroupStateEnum statStateEnum = GroupStateEnum.forValue((int)state);
                group.setState(statStateEnum);
                List columnList = JsonUtil.toJavaObjectList((String)columns, Column.class);
                group.setColumns(columnList);
            }
            return group;
        }
    }
}

