/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.modal.Record;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import java.sql.Connection;
import java.time.LocalDateTime;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.Validate;

public final class LimitingWrapper {
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void record(Record limitingRecord) throws Exception {
        Validate.notNull((Object)limitingRecord);
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        String sql = "INSERT INTO ldp_records (`resource_id`, `resource_type`,`record_type`,`extend`,`create_time`) VALUES (?, ?, ?, ?, ?)";
        LocalDateTime localDateTime = LocalDateTime.now();
        try {
            queryRunner.insert(conn, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{limitingRecord.getResourceId(), limitingRecord.getResourceType().getResourceType(), limitingRecord.getRecordType().getRecordType(), limitingRecord.getExtend(), localDateTime});
        }
        finally {
            storageEngine.closeConnection();
        }
    }
}

