/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.enums.MetaTableStateEnum;
import com.dtstep.lighthouse.common.enums.MetaTableTypeEnum;
import com.dtstep.lighthouse.common.modal.MetaTable;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaTableWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MetaTableWrapper.class);
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Cache<Integer, Optional<MetaTable>> META_CACHE = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(10000L).softValues().build();

    public static MetaTable queryById(int metaId) {
        Optional optional = (Optional)META_CACHE.get((Object)metaId, k -> MetaTableWrapper.actualQueryById(metaId));
        assert (optional != null);
        return optional.orElse(null);
    }

    private static Optional<MetaTable> actualQueryById(int metaId) {
        MetaTable metaTable = null;
        try {
            metaTable = MetaTableWrapper.queryMetaByIdFromDB(metaId);
            if (metaTable != null) {
                String metaName = metaTable.getMetaName();
                if (!WarehouseStorageEngineProxy.getInstance().isTableExist(metaName)) {
                    WarehouseStorageEngineProxy.getInstance().createResultTable(metaName);
                }
            }
        }
        catch (Exception ex) {
            logger.error("query metatable info error!", (Throwable)ex);
        }
        return Optional.ofNullable(metaTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetaTable queryMetaByIdFromDB(int metaId) throws Exception {
        MetaTable metaTable;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            metaTable = (MetaTable)queryRunner.query(conn, String.format("select * from ldp_metas where id = '%s'", metaId), (ResultSetHandler)new MetaResultSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return metaTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertIntoMySQL(MetaTable metaTable) throws Exception {
        BigInteger id;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        String sql = "INSERT INTO ldp_metas (`meta_name`, `type`, `state`,`record_size`,`content_size`,`desc`,`create_time`,`update_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        LocalDateTime localDateTime = LocalDateTime.now();
        try {
            id = (BigInteger)queryRunner.insert(conn, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{metaTable.getMetaName(), metaTable.getMetaTableType().getType(), metaTable.getState().getState(), 0, 0, null, localDateTime, localDateTime});
        }
        finally {
            storageEngine.closeConnection();
        }
        return id.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteTable(String tableName) {
        try {
            Connection conn = storageEngine.getConnection();
            QueryRunner queryRunner = new QueryRunner();
            String sql = "DELETE from ldp_metas where meta_name = ?";
            try {
                queryRunner.update(conn, sql, (Object)tableName);
            }
            finally {
                storageEngine.closeConnection();
            }
            logger.info("drop meta table success,metaName:{}", (Object)tableName);
        }
        catch (Exception ex) {
            logger.error("drop meta table failed,metaName:{}", (Object)tableName, (Object)ex);
        }
        try {
            WarehouseStorageEngineProxy.getInstance().dropTable(tableName);
            logger.info("drop storage table success,metaName:{}", (Object)tableName);
        }
        catch (Exception ex) {
            logger.error("drop storage table failed,metaName:{}", (Object)tableName, (Object)ex);
        }
    }

    public static int createStatStorageAndMetaTable() throws Exception {
        int tableId;
        MetaTable metaTable = new MetaTable();
        String metaName = "ldp_stat_" + System.currentTimeMillis();
        metaTable.setMetaName(metaName);
        metaTable.setState(MetaTableStateEnum.VALID);
        LocalDateTime date = LocalDateTime.now();
        metaTable.setCreateTime(date);
        metaTable.setUpdateTime(date);
        metaTable.setMetaTableType(MetaTableTypeEnum.STAT_RESULT_TABLE);
        try {
            WarehouseStorageEngineProxy.getInstance().createResultTable(metaName);
            logger.info("create storage table success,metaName:{}", (Object)metaName);
        }
        catch (Exception ex) {
            logger.error("create storage table error,metaName:{}", (Object)metaName, (Object)ex);
            throw ex;
        }
        try {
            tableId = MetaTableWrapper.insertIntoMySQL(metaTable);
            logger.info("save storage table meta info success,metaName;{}", (Object)metaName);
        }
        catch (Exception ex) {
            logger.error("save storage table meta info error,metaName:{}", (Object)metaName, (Object)ex);
            MetaTableWrapper.deleteTable(metaName);
            throw ex;
        }
        return tableId;
    }

    private static class MetaResultSetHandler
    implements ResultSetHandler<MetaTable> {
        private MetaResultSetHandler() {
        }

        public MetaTable handle(ResultSet rs) throws SQLException {
            MetaTable metaTable = null;
            if (rs.next()) {
                metaTable = new MetaTable();
                int id = rs.getInt("id");
                String metaName = rs.getString("meta_name");
                int type = rs.getInt("type");
                int state = rs.getInt("state");
                int recordSize = rs.getInt("record_size");
                int contentSize = rs.getInt("content_size");
                String desc = rs.getString("desc");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                metaTable.setId(id);
                metaTable.setMetaName(metaName);
                metaTable.setMetaTableType(MetaTableTypeEnum.getMetaTableTypeEnum((int)type));
                metaTable.setState(MetaTableStateEnum.forValue((int)state));
                metaTable.setRecordSize((long)recordSize);
                metaTable.setContentSize((long)contentSize);
                metaTable.setDesc(desc);
                metaTable.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                metaTable.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
            }
            return metaTable;
        }
    }
}

