/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionDBWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PermissionDBWrapper.class);
    private static final Integer _CacheExpireMinutes = 3;
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Cache<Object, Optional<Boolean>> PERMISSION_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();

    public static boolean hasPermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId) throws Exception {
        Optional optional = (Optional)PERMISSION_CACHE.get((Object)("HasPermission-" + ownerId + "-" + ownerTypeEnum + "-" + roleId), k -> PermissionDBWrapper.actualHashPermission(ownerId, ownerTypeEnum, roleId));
        assert (optional != null);
        return optional.orElse(false);
    }

    public static Optional<Boolean> actualHashPermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId) {
        Boolean bool = null;
        try {
            bool = PermissionDBWrapper.checkPermissionFromDB(ownerId, ownerTypeEnum, roleId);
        }
        catch (Exception ex) {
            logger.error("check permission info error!", (Throwable)ex);
        }
        return Optional.ofNullable(bool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean checkPermissionFromDB(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId) throws Exception {
        Boolean bool;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            bool = (Boolean)queryRunner.query(conn, String.format("WITH RECURSIVE role_hierarchy AS (\n    SELECT id, pid\n    FROM ldp_roles\n    WHERE id = '%s'\n    UNION ALL\n    SELECT r.id, r.pid\n    FROM ldp_roles r\n    INNER JOIN role_hierarchy rh ON rh.pid = r.id\n)\n\nSELECT \n    CASE WHEN EXISTS (\n        SELECT 1\n        FROM ldp_permissions p\n        INNER JOIN role_hierarchy rh ON rh.id = p.role_id\n        WHERE p.owner_id = '%s'\n        AND p.owner_type = '%s'\n        AND (p.expire_time = null || p.expire_time > NOW())\n    )\n    THEN 'true'\n    ELSE 'false'\n    END AS has_permission", roleId, ownerId, ownerTypeEnum.getOwnerType()), (ResultSetHandler)new PermissionSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return bool;
    }

    private static class PermissionSetHandler
    implements ResultSetHandler<Boolean> {
        private PermissionSetHandler() {
        }

        public Boolean handle(ResultSet rs) throws SQLException {
            boolean bool = false;
            if (rs.next()) {
                bool = rs.getBoolean(1);
            }
            return bool;
        }
    }
}

