/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash_snp;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash_snp.HashCode;
import com.google.common.hash_snp.HashFunction;
import com.google.common.hash_snp.Hasher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super((OutputStream)Preconditions.checkNotNull((Object)out));
        this.hasher = (Hasher)Preconditions.checkNotNull((Object)hashFunction.newHasher());
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

