/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.tasks.executive;

import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.util.FileUtil;
import com.dtstep.lighthouse.common.util.SnappyUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.consumer.AggregateEvent;
import com.dtstep.lighthouse.core.message.RetrenchMessage;
import com.dtstep.lighthouse.tasks.executive.LightHouseEntrance;
import com.dtstep.lighthouse.tasks.executive.LightHouseEntrance$;
import com.dtstep.lighthouse.tasks.listener.ListenerTrigger;
import com.dtstep.lighthouse.tasks.stream.NormalStream;
import com.dtstep.lighthouse.tasks.transform.PreTransform;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.Trigger;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.LazyRef;

public final class LightHouseEntrance$
implements Logging {
    public static LightHouseEntrance$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new LightHouseEntrance$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        public final class Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator2$1() {
            }
        }
        public final class Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator1$1() {
            }
        }
        String[] stringArray;
        Option option;
        LazyRef sparkConf$lzy = new LazyRef();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Please enter the configuration file(ldp-site.xml) path,system exit!");
            System.exit(1);
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String sitePath = (String)((SeqLike)option.get()).apply(0);
        String sitePath2 = sitePath;
        if (!FileUtil.isFileExist((String)sitePath2)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The configuration file(ldp-site.xml) does not exist,system exit!");
            System.exit(1);
        }
        try {
            LDPConfig.init((String)sitePath2);
        }
        catch (Exception ex) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load configuration file(ldp-site.xml),system exit!", ex);
            System.exit(1);
        }
        String kafkaServers = LDPConfig.getVal((String)"kafka.bootstrap.servers");
        String topic = LDPConfig.getVal((String)"kafka.topic.name");
        String[] stringArray2 = (String[])((Object[])new String[]{kafkaServers, topic});
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) < 0) {
            throw new MatchError((Object)stringArray2);
        }
        String bootstrapServers = (String)((SeqLike)option2.get()).apply(0);
        String topics = (String)((SeqLike)option2.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)bootstrapServers, (Object)topics);
        String bootstrapServers2 = (String)tuple2._1();
        String topics2 = (String)tuple2._2();
        SparkSession spark = SparkSession$.MODULE$.builder().config(LightHouseEntrance$.sparkConf$1(sparkConf$lzy)).getOrCreate();
        spark.sparkContext().addSparkListener((SparkListenerInterface)new ListenerTrigger());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        spark.udf().register("deserialize", (Function1 & Serializable & scala.Serializable)bytes -> {
            if (SnappyUtil.isCompress((byte[])bytes)) {
                return SnappyUtil.uncompressByte((byte[])bytes);
            }
            return new String((byte[])bytes, StandardCharsets.UTF_8);
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_dtstep_lighthouse_tasks_executive_LightHouseEntrance$$typecreator2$1()));
        spark.sparkContext().addFile(sitePath2);
        Dataset kafkaDataSets = spark.readStream().format("kafka").option("kafka.bootstrap.servers", bootstrapServers2).option("enable.auto.commit", "false").option("subscribe", topics2).option("kafka.session.timeout.ms", "120000").option("kafka.request.timeout.ms", "90000").option("kafka.default.api.timeout.ms", "180000").option("kafka.allow.auto.create.topics", "false").option("kafka.max.poll.interval.ms", "1500000").option("kafka.fetch.max.wait.ms", "2000").option("kafka.fetch.max.bytes", "2097152").option("kafka.connections.max.idle.ms", "1080000").option("kafka.max.partition.fetch.bytes", "2097152").option("kafka.max.poll.records", "300").option("kafkaConsumer.pollTimeoutMs", "180000").option("kafka.partition.assignment.strategy", "org.apache.kafka.clients.consumer.StickyAssignor").option("startingOffsets", "latest").option("fetchOffset.numRetries", "5").option("failOnDataLoss", "false").load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deserialize(value) AS message"})).as(spark.implicits().newStringEncoder());
        PreTransform transform = new PreTransform(spark);
        Dataset<Tuple2<Object, LightMessage>> flowData = transform.process((Dataset<String>)kafkaDataSets);
        this.processNormalRequest(flowData);
        spark.streams().awaitAnyTermination();
        spark.stop();
    }

    private void processNormalRequest(Dataset<Tuple2<Object, LightMessage>> flowData) {
        String string;
        SparkSession spark = flowData.sparkSession();
        boolean isRunningOnYarn = spark.sparkContext().master().startsWith("yarn");
        if (isRunningOnYarn) {
            string = "/lighthouse/checkpoint/normal";
        } else {
            String arg$macro$1 = LDPConfig.getHomeDir();
            string = new StringOps("%s/data/lighthouse/checkpoint/normal").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
        }
        String checkpointLocation = string;
        NormalStream normalStream = new NormalStream(spark);
        Dataset<Tuple3<Object, String, Object>> normalDataSet = normalStream.part(flowData);
        normalDataSet.writeStream().queryName("NormalStream").option("checkpointLocation", checkpointLocation).foreach((ForeachWriter)new LightHouseEntrance.ItemForeachWriter()).outputMode(OutputMode.Append()).trigger(Trigger.ProcessingTime((long)TimeUnit.SECONDS.toMillis(5L))).start();
    }

    private static final /* synthetic */ SparkConf sparkConf$lzycompute$1(LazyRef sparkConf$lzy$1) {
        SparkConf sparkConf;
        LazyRef lazyRef = sparkConf$lzy$1;
        synchronized (lazyRef) {
            sparkConf = sparkConf$lzy$1.initialized() ? (SparkConf)sparkConf$lzy$1.value() : (SparkConf)sparkConf$lzy$1.initialize((Object)new SparkConf().setAppName("LightHouseEntrance").set("spark.kryoserializer.buffer.max", "128m").set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.shuffle.consolidateFiles", "true").set("spark.network.timeout", "600000").set("spark.ui.killEnabled", "false").set("spark.default.parallelism", "500").set("spark.sql.shuffle.partitions", "500").set("spark.scheduler.listenerbus.eventqueue.capacity", "20000").set("spark.kryo.registrationRequired", "false").set("spark.shuffle.file.buffer", "32k").set("spark.kafka.consumer.cache.capacity", "256").set("spark.kafka.consumer.cache.timeout", "1m").set("spark.reducer.maxSizeInFlight", "96m").set("spark.io.compression.lz4.blockSize", "16k").registerKryoClasses((Class[])((Object[])new Class[]{LightMessage.class, RetrenchMessage.class, AggregateEvent.class, Pair.class, Triple.class, MicroBucket.class})));
        }
        return sparkConf;
    }

    private static final SparkConf sparkConf$1(LazyRef sparkConf$lzy$1) {
        if (sparkConf$lzy$1.initialized()) {
            return (SparkConf)sparkConf$lzy$1.value();
        }
        return LightHouseEntrance$.sparkConf$lzycompute$1(sparkConf$lzy$1);
    }

    private LightHouseEntrance$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

