/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.tasks.part;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.result.MessageCaptchaEnum;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.distinct.RedisRoaringFilter;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.limiting.LimitingContext;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.wrapper.DimensDBWrapper;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.tasks.part.Partition;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash_snp.Hashing;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!\u0002\u000b\u0016\u0001]y\u0002\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b9\u0003A\u0011A(\t\u000fI\u0003!\u0019!C\u0005'\"1!\f\u0001Q\u0001\nQCQa\u0017\u0001\u0005\u0004qCq\u0001\u001e\u0001C\u0002\u0013\rQ\u000f\u0003\u0004x\u0001\u0001\u0006IA\u001e\u0005\bq\u0002\u0011\r\u0011b\u0001z\u0011\u001d\tI\u0001\u0001Q\u0001\niDq!a\u0003\u0001\t\u0007\ti\u0001C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024!A\u0011\u0011\n\u0001!\u0002\u0013\t)\u0004\u0003\u0004\u0017\u0001\u0011\u0005\u00131\n\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u00028\u0002!\t!!/\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}'!E%uK6\u001cF/\u0019;QCJ$\u0018\u000e^5p]*\u0011acF\u0001\u0005a\u0006\u0014HO\u0003\u0002\u00193\u0005)A/Y:lg*\u0011!dG\u0001\u000bY&<\u0007\u000e\u001e5pkN,'B\u0001\u000f\u001e\u0003\u0019!Go\u001d;fa*\ta$A\u0002d_6\u001cB\u0001\u0001\u0011'yA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u00042a\n\u0015+\u001b\u0005)\u0012BA\u0015\u0016\u0005%\u0001\u0016M\u001d;ji&|g\u000eE\u0003\"W5\u0002T&\u0003\u0002-E\t1A+\u001e9mKN\u0002\"!\t\u0018\n\u0005=\u0012#aA%oiB\u0011\u0011'\u000f\b\u0003e]\u0002\"a\r\u0012\u000e\u0003QR!!\u000e\u001c\u0002\rq\u0012xn\u001c;?\u0007\u0001I!\u0001\u000f\u0012\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q\t\u0002\"!\u0010$\u000e\u0003yR!a\u0010!\u0002\u0011%tG/\u001a:oC2T!!\u0011\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0005\u0003\u000fz\u0012q\u0001T8hO&tw\r\u0005\u0002J\u00196\t!J\u0003\u0002L\u0001\u0006\u00191/\u001d7\n\u00055S%\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002Q#B\u0011q\u0005\u0001\u0005\u0006\u0003\n\u0001\r\u0001S\u0001\u0007Y><w-\u001a:\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016#\u0002\u000bMdg\r\u000e6\n\u0005e3&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\rMLgn\u001a7f+\ti6\r\u0006\u0002_YB\u0019\u0011jX1\n\u0005\u0001T%aB#oG>$WM\u001d\t\u0003E\u000ed\u0001\u0001B\u0003e\u000b\t\u0007QMA\u0001B#\t1\u0017\u000e\u0005\u0002\"O&\u0011\u0001N\t\u0002\b\u001d>$\b.\u001b8h!\t\t#.\u0003\u0002lE\t\u0019\u0011I\\=\t\u000b5,\u00019\u00018\u0002\u0003\r\u00042a\u001c:b\u001b\u0005\u0001(BA9#\u0003\u001d\u0011XM\u001a7fGRL!a\u001d9\u0003\u0011\rc\u0017m]:UC\u001e\fQb\u0018;va2,WI\\2pI\u0016\u0014X#\u0001<\u0011\u0007%{&&\u0001\b`iV\u0004H.Z#oG>$WM\u001d\u0011\u0002\u0019}c\u0017n\u001d;F]\u000e|G-\u001a:\u0016\u0003i\u00042!S0|!\u0011a\u00181\u0001\u0016\u000f\u0005u|hBA\u001a\u007f\u0013\u0005\u0019\u0013bAA\u0001E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u0011A\u0001T5ti*\u0019\u0011\u0011\u0001\u0012\u0002\u001b}c\u0017n\u001d;F]\u000e|G-\u001a:!\u00039yF/\u001e9mK\u0016s7m\u001c3feJ*b!a\u0004\u0002\u001c\u0005\u0005BCBA\t\u0003K\tY\u0003\u0005\u0003J?\u0006M\u0001cB\u0011\u0002\u0016\u0005e\u0011qD\u0005\u0004\u0003/\u0011#A\u0002+va2,'\u0007E\u0002c\u00037!a!!\b\u000b\u0005\u0004)'AA!2!\r\u0011\u0017\u0011\u0005\u0003\u0007\u0003GQ!\u0019A3\u0003\u0005\u0005\u0013\u0004bBA\u0014\u0015\u0001\u000f\u0011\u0011F\u0001\u0003KF\u0002B!S0\u0002\u001a!9\u0011Q\u0006\u0006A\u0004\u0005=\u0012AA33!\u0011Iu,a\b\u0002\u0019-,\u0017pR3oKJ\fGo\u001c:\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005S6\u0004HN\u0003\u0003\u0002@\u0005\u0005\u0013A\u0002:po.,\u0017PC\u0002\u0002De\tAaY8sK&!\u0011qIA\u001d\u0005M!UMZ1vYR\\U-_$f]\u0016\u0014\u0018\r^8s\u00035YW-_$f]\u0016\u0014\u0018\r^8sAQ!\u0011QJA*!\u0011I\u0015q\n\u0016\n\u0007\u0005E#JA\u0004ECR\f7/\u001a;\t\u000f\u0005US\u00021\u0001\u0002X\u0005\u0011Am\u001d\t\u0006\u0013\u0006=\u0013\u0011\f\t\u0007C\u0005UQ&a\u0017\u0011\t\u0005u\u00131N\u0007\u0003\u0003?RA!!\u0019\u0002d\u00059Q.Z:tC\u001e,'\u0002BA3\u0003O\na!\u001a8uSRL(bAA53\u000511m\\7n_:LA!!\u001c\u0002`\taA*[4ii6+7o]1hK\u0006a\u0011n]:vK6+7o]1hKR)10a\u001d\u0002x!1\u0011Q\u000f\bA\u00025\nqaY1qi\u000eD\u0017\rC\u0004\u0002b9\u0001\r!a\u0017\u0002\r\u0015D\b/\u00198e)\u0015Y\u0018QPA@\u0011\u0019\t)h\u0004a\u0001[!9\u0011\u0011M\bA\u0002\u0005m\u0013AB1qa\u0016tG\r\u0006\u0005\u0002\u0006\u0006U\u0015QUA[!\u0015\t9)!%+\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001f\u0013\u0013AC2pY2,7\r^5p]&!\u00111SAE\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\u0005\b\u0003/\u0003\u0002\u0019AAM\u0003)\u0019H/\u0019;F]RLG/\u001f\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*!\u0011qTA2\u0003\u0011\u0019H/\u0019;\n\t\u0005\r\u0016Q\u0014\u0002\u000e'R\fG/\u0012=u\u000b:$\u0018\u000e^=\t\u000f\u0005\u001d\u0006\u00031\u0001\u0002*\u0006YqM]8va\u0016sG/\u001b;z!\u0011\tY+!-\u000e\u0005\u00055&\u0002BAX\u0003G\nQa\u001a:pkBLA!a-\u0002.\nqqI]8va\u0016CH/\u00128uSRL\bbBA1!\u0001\u0007\u00111L\u0001\u001aCB\u0004XM\u001c3He>,\b/T3tg\u0006<W-T8oSR|'\u000f\u0006\u0004\u0002\u0006\u0006m\u0016\u0011\u001b\u0005\b\u0003{\u000b\u0002\u0019AA`\u0003!\u0001\u0018M]1n\u001b\u0006\u0004\bCBAa\u0003\u001b\u0004\u0004'\u0004\u0002\u0002D*!\u0011QYAd\u0003\u001d\u0019w\u000e\u001c7fGRTA!!\u001b\u0002J*\u0019\u00111Z\u000f\u0002\r\u001d|wn\u001a7f\u0013\u0011\ty-a1\u0003\u0019%kW.\u001e;bE2,W*\u00199\t\r\u0005M\u0017\u00031\u0001.\u0003\u0019\u0011X\r]3bi\u00069\u0012\r\u001d9f]\u0012\u001cF/\u0019;SKN,H\u000e^'p]&$xN\u001d\u000b\u0007\u0003\u000b\u000bI.a7\t\u000f\u0005u&\u00031\u0001\u0002@\"1\u00111\u001b\nA\u00025\nqaZ3u'2|G\u000fF\u0002.\u0003CDa!a9\u0014\u0001\u0004\u0001\u0014\u0001D1hOJ,w-\u0019;f\u0017\u0016L\b")
public class ItemStatPartition
implements Partition<Tuple3<Object, String, Object>>,
Logging {
    private final Logger logger;
    private final Encoder<Tuple3<Object, String, Object>> _tupleEncoder;
    private final Encoder<List<Tuple3<Object, String, Object>>> _listEncoder;
    private final DefaultKeyGenerator keyGenerator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public List<StatExtEntity> getEffectiveStats(int groupId) {
        return Partition.getEffectiveStats$(this, groupId);
    }

    @Override
    public int getThreshold(GroupExtEntity group, LimitingStrategyEnum strategy) {
        return Partition.getThreshold$(this, group, strategy);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    public <A> Encoder<A> single(ClassTag<A> c) {
        return Encoders$.MODULE$.kryo(c);
    }

    public Encoder<Tuple3<Object, String, Object>> _tupleEncoder() {
        return this._tupleEncoder;
    }

    public Encoder<List<Tuple3<Object, String, Object>>> _listEncoder() {
        return this._listEncoder;
    }

    public <A1, A2> Encoder<Tuple2<A1, A2>> _tupleEncoder2(Encoder<A1> e1, Encoder<A2> e2) {
        return Encoders$.MODULE$.tuple(e1, e2);
    }

    public DefaultKeyGenerator keyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public Dataset<Tuple3<Object, String, Object>> part(Dataset<Tuple2<Object, LightMessage>> ds) {
        return ds.map((Function1 & Serializable & scala.Serializable)x -> this.issueMessage(x._1$mcI$sp(), (LightMessage)x._2()), this._listEncoder()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ItemStatPartition.$anonfun$part$2(x))).flatMap((Function1 & Serializable & scala.Serializable)x -> x, this._tupleEncoder());
    }

    private List<Tuple3<Object, String, Object>> issueMessage(int captcha, LightMessage message) {
        List<Tuple3<Object, String, Object>> list = null;
        try {
            list = this.expand(captcha, message);
        }
        catch (Exception ex) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "issue message error!", ex);
        }
        return list;
    }

    private List<Tuple3<Object, String, Object>> expand(int captcha, LightMessage message) {
        BoxedUnit boxedUnit;
        GroupExtEntity groupEntity;
        block8: {
            block7: {
                groupEntity = GroupDBWrapper.queryById((int)message.getGroupId());
                if (groupEntity == null) break block7;
                GroupStateEnum groupStateEnum = groupEntity.getState();
                GroupStateEnum groupStateEnum2 = GroupStateEnum.RUNNING;
                if (!(groupStateEnum == null ? groupStateEnum2 != null : !groupStateEnum.equals(groupStateEnum2))) break block8;
            }
            return null;
        }
        ListBuffer list = new ListBuffer();
        if (!groupEntity.isBuiltIn()) {
            ImmutableMap paramMap = ImmutableMap.of((Object)"groupId", (Object)groupEntity.getId().toString(), (Object)"captcha", (Object)Integer.toString(captcha));
            boxedUnit = list.$plus$plus$eq(this.appendGroupMessageMonitor((ImmutableMap<String, String>)paramMap, message.getRepeat()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (captcha != MessageCaptchaEnum.SUCCESS.getCaptcha()) {
            return list.toList();
        }
        List<StatExtEntity> statList = this.getEffectiveStats(Predef$.MODULE$.Integer2int(groupEntity.getId()));
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(new StringBuilder(36).append("Group:").append(groupEntity.getId()).append(",valid statistical items size:").append(statList.size()).toString());
        }
        statList.foreach((Function1 & Serializable & scala.Serializable)statEntity -> list.$plus$plus$eq(this.append((StatExtEntity)statEntity, groupEntity, message)));
        return list.toList();
    }

    public ListBuffer<Tuple3<Object, String, Object>> append(StatExtEntity statEntity, GroupExtEntity groupEntity, LightMessage message) {
        ListBuffer list = new ListBuffer();
        TemplateEntity templateEntity = statEntity.getTemplateEntity();
        ObjectRef dimensValue = ObjectRef.create(null);
        long batchTime = DateUtil.batchTime((int)statEntity.getTimeParamInterval(), (TimeUnit)statEntity.getTimeUnit(), (long)message.getTime());
        HashMap envMap = new HashMap(message.getParamMap());
        if (!StringUtil.isEmpty((String)templateEntity.getDimens())) {
            dimensValue.elem = DimensDBWrapper.getDimensValue(envMap, (String[])templateEntity.getDimensArray(), (long)batchTime);
            int threshold = this.getThreshold(groupEntity, LimitingStrategyEnum.STAT_RESULT_SIZE_LIMITING);
            if (!LimitingContext.getInstance().tryAcquire(statEntity, threshold, 1)) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("limiting trigger strategy:STAT_RESULT_SIZE_LIMIT,token:").append(groupEntity.getToken()).append(",stat:").append(statEntity.getId()).append(",threshold:").append((long)threshold * 60L).toString());
                return list;
            }
        }
        Buffer statStateList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(templateEntity.getStatStateList()).asScala();
        statStateList.foreach((Function1 & Serializable & scala.Serializable)statState -> {
            BoxedUnit boxedUnit;
            try {
                BoxedUnit boxedUnit2;
                Object object;
                boolean isDistinct = StatState.isBitCountState((StatState)statState);
                ObjectRef distinctValue = ObjectRef.create(null);
                if (isDistinct) {
                    distinctValue.elem = String.valueOf(FormulaCalculate.parseVariableEntity((String)StatState.getFirstUnit((StatState)statState), (Map)envMap, (long)batchTime));
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("expand message,stat:").append(statEntity.getId()).append(",envMap:").append(JsonUtil.toJSONString((Object)envMap)).append(",batchTime:").append(DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss")).append(",distinctValue:").append((String)distinctValue$1.elem).toString());
                    distinctValue.elem = RedisRoaringFilter.getInstance().concatDistinctValue((String)distinctValue.elem, (String)dimensValue$1.elem, batchTime);
                    long hash = Hashing.murmur3_128().hashBytes(((String)distinctValue.elem).getBytes(StandardCharsets.UTF_8)).asLong();
                    distinctValue.elem = Long.toString(Math.abs(hash), 36);
                    object = envMap.put("_d", (String)distinctValue.elem);
                } else {
                    object = BoxedUnit.UNIT;
                }
                String aggregateKey = this.keyGenerator().resultKey((Stat)statEntity, statState.getFunctionIndex(), (String)dimensValue$1.elem, batchTime);
                if (!groupEntity.isBuiltIn()) {
                    ImmutableMap paramMap = ImmutableMap.of((Object)"statId", (Object)statEntity.getId().toString(), (Object)"resultKey", (Object)aggregateKey);
                    boxedUnit2 = list.$plus$plus$eq(this.appendStatResultMonitor((ImmutableMap<String, String>)paramMap, message.getRepeat()));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                String data = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)envMap).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ItemStatPartition.$anonfun$append$4(statState, x)))).map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(1).append((String)x._1()).append("\u0006").append(x._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\u0005");
                String result = StringBuilderHolder.Smaller.getStringBuilder().append(aggregateKey).append("\u0004").append(statEntity.getId()).append("\u0004").append(data).append("\u0004").append((String)dimensValue$1.elem).append("\u0004").append(statState.getFunctionIndex()).append("\u0004").append(batchTime).toString();
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("deliver stat message,statId:").append(statEntity.getId()).append(",distinct:").append((String)distinctValue$1.elem).append(",evnMap:").append(JsonUtil.toJSONString((Object)envMap)).append(",dimens:").append((String)dimensValue$1.elem).append(",repeat:").append(message.getRepeat()).append(",result:").append(result).append(",batch:").append(DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss")).toString());
                boxedUnit = list.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.getSlot(aggregateKey)), (Object)result, (Object)BoxesRunTime.boxToInteger((int)message.getRepeat())));
            }
            catch (Exception ex) {
                this.logger().error(new StringBuilder(28).append("deliver message error,group:").append(message.getGroupId()).toString(), (Throwable)ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return list;
    }

    public ListBuffer<Tuple3<Object, String, Object>> appendGroupMessageMonitor(ImmutableMap<String, String> paramMap, int repeat) {
        ListBuffer list = new ListBuffer();
        GroupExtEntity monitorGroup = BuiltinLoader.getBuiltinGroup((String)"_builtin_msg_stat");
        LightMessage monitorMessage = new LightMessage();
        monitorMessage.setParamMap(paramMap);
        monitorMessage.setGroupId(Predef$.MODULE$.Integer2int(monitorGroup.getId()));
        monitorMessage.setRepeat(repeat);
        monitorMessage.setTime(System.currentTimeMillis());
        java.util.List monitorStats = BuiltinLoader.getBuiltinStatByGroupId((int)Predef$.MODULE$.Integer2int(monitorGroup.getId()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(monitorStats).asScala()).foreach((Function1 & Serializable & scala.Serializable)monitorStat -> list.$plus$plus$eq(this.append((StatExtEntity)monitorStat, monitorGroup, monitorMessage)));
        return list;
    }

    public ListBuffer<Tuple3<Object, String, Object>> appendStatResultMonitor(ImmutableMap<String, String> paramMap, int repeat) {
        ListBuffer list = new ListBuffer();
        GroupExtEntity monitorGroup = BuiltinLoader.getBuiltinGroup((String)"_builtin_result_stat");
        LightMessage monitorMessage = new LightMessage();
        monitorMessage.setParamMap(paramMap);
        monitorMessage.setGroupId(Predef$.MODULE$.Integer2int(monitorGroup.getId()));
        monitorMessage.setRepeat(repeat);
        monitorMessage.setTime(System.currentTimeMillis());
        java.util.List monitorStats = BuiltinLoader.getBuiltinStatByGroupId((int)Predef$.MODULE$.Integer2int(monitorGroup.getId()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(monitorStats).asScala()).foreach((Function1 & Serializable & scala.Serializable)monitorStat -> list.$plus$plus$eq(this.append((StatExtEntity)monitorStat, monitorGroup, monitorMessage)));
        return list;
    }

    public int getSlot(String aggregateKey) {
        return HashUtil.getHashIndex((String)aggregateKey, (int)10);
    }

    public static final /* synthetic */ boolean $anonfun$part$2(List x) {
        return x != null && x.nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$append$4(StatState statState$1, Tuple2 x) {
        return statState$1.getRelatedColumnSet().contains(x._1()) || ((String)x._1()).equals("_d");
    }

    public ItemStatPartition(SparkSession spark) {
        Partition.$init$(this);
        Logging.$init$((Logging)this);
        this.logger = LoggerFactory.getLogger(ItemStatPartition.class);
        this._tupleEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Tuple3.class));
        this._listEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(List.class));
        this.keyGenerator = new DefaultKeyGenerator();
    }
}

