/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.tasks.valid;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.enums.result.MessageCaptchaEnum;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.limiting.LimitingContext;
import com.dtstep.lighthouse.core.limiting.RedisLimitingAspect;
import com.dtstep.lighthouse.core.preparing.handler.valid.MessageValid;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.tasks.valid.ValidHandler;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c!\u0002\u0007\u000e\u0001=9\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bq\u0002A\u0011A\u001f\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1\u0001\n\u0001Q\u0001\n\tCQA\u0004\u0001\u0005B%CQA\u0014\u0001\u0005\u0002=CQa\u0018\u0001\u0005\u0002\u0001DQa\u001a\u0001\u0005\u0002!DQA\u001d\u0001\u0005\u0004MDq!a\u0005\u0001\t\u0007\t)\u0002\u0003\u0004\u000f\u0001\u0011\u0005\u0013q\u0007\u0002\u0014\t\u00164\u0017-\u001e7u-\u0006d\u0017\u000e\u001a%b]\u0012dWM\u001d\u0006\u0003\u001d=\tQA^1mS\u0012T!\u0001E\t\u0002\u000bQ\f7o[:\u000b\u0005I\u0019\u0012A\u00037jO\"$\bn\\;tK*\u0011A#F\u0001\u0007IR\u001cH/\u001a9\u000b\u0003Y\t1aY8n'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\t}\u0001#%J\u0007\u0002\u001b%\u0011\u0011%\u0004\u0002\r-\u0006d\u0017\u000e\u001a%b]\u0012dWM\u001d\t\u00033\rJ!\u0001\n\u000e\u0003\u0007%sG\u000f\u0005\u0002'[5\tqE\u0003\u0002)S\u00059Q.Z:tC\u001e,'B\u0001\u0016,\u0003\u0019)g\u000e^5us*\u0011A&E\u0001\u0007G>lWn\u001c8\n\u00059:#\u0001\u0004'jO\"$X*Z:tC\u001e,\u0017!B:qCJ\\7\u0001\u0001\t\u0003eij\u0011a\r\u0006\u0003iU\n1a]9m\u0015\tycG\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e4\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011ah\u0010\t\u0003?\u0001AQa\f\u0002A\u0002E\na\u0001\\8hO\u0016\u0014X#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0014!B:mMRR\u0017BA$E\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004CC\u0001&N!\u0011I2JI\u0013\n\u00051S\"A\u0002+va2,'\u0007C\u0003)\u000b\u0001\u0007Q%\u0001\u0007hKR$\u0006N]3tQ>dG\rF\u0002#!^CQ!\u0015\u0004A\u0002I\u000bQa\u001a:pkB\u0004\"aU+\u000e\u0003QS!!U\u0015\n\u0005Y#&AD$s_V\u0004X\t\u001f;F]RLG/\u001f\u0005\u00061\u001a\u0001\r!W\u0001\tgR\u0014\u0018\r^3hsB\u0011!,X\u0007\u00027*\u0011AlK\u0001\u0006K:,Xn]\u0005\u0003=n\u0013A\u0003T5nSRLgnZ*ue\u0006$XmZ=F]Vl\u0017aB2baR,(/\u001a\u000b\u0004C\u00124\u0007CA\rc\u0013\t\u0019'D\u0001\u0003V]&$\b\"B3\b\u0001\u0004\u0011\u0013aB4s_V\u0004\u0018\n\u001a\u0005\u0006Q\u001d\u0001\r!J\u0001\rm\u0006d\u0017\u000eZ'fgN\fw-\u001a\u000b\u0004S>\u0004\bC\u00016n\u001b\u0005Y'B\u00017\\\u0003\u0019\u0011Xm];mi&\u0011an\u001b\u0002\u0013\u001b\u0016\u001c8/Y4f\u0007\u0006\u0004Ho\u00195b\u000b:,X\u000eC\u0003)\u0011\u0001\u0007Q\u0005C\u0003r\u0011\u0001\u0007!+A\u0005ti\u0006$xI]8va\u000611/\u001b8hY\u0016,2\u0001^A\u0001)\t)\b\u0010E\u00023m*K!a^\u001a\u0003\u000f\u0015s7m\u001c3fe\")\u00110\u0003a\u0002u\u0006\t1\rE\u0002|}*k\u0011\u0001 \u0006\u0003{j\tqA]3gY\u0016\u001cG/\u0003\u0002\u0000y\nA1\t\\1tgR\u000bw\rB\u0004\u0002\u0004%\u0011\r!!\u0002\u0003\u0003\u0005\u000bB!a\u0002\u0002\u000eA\u0019\u0011$!\u0003\n\u0007\u0005-!DA\u0004O_RD\u0017N\\4\u0011\u0007e\ty!C\u0002\u0002\u0012i\u00111!\u00118z\u0003\u0015!X\u000f\u001d7f+\u0019\t9\"!\t\u0002(Q1\u0011\u0011DA\u0016\u0003c\u0001BA\r<\u0002\u001cA1\u0011dSA\u000f\u0003K\u0001B!a\b\u0002\"1\u0001AaBA\u0012\u0015\t\u0007\u0011Q\u0001\u0002\u0003\u0003F\u0002B!a\b\u0002(\u00119\u0011\u0011\u0006\u0006C\u0002\u0005\u0015!AA!3\u0011\u001d\tiC\u0003a\u0002\u0003_\t!!Z\u0019\u0011\tI2\u0018Q\u0004\u0005\b\u0003gQ\u00019AA\u001b\u0003\t)'\u0007\u0005\u00033m\u0006\u0015B\u0003BA\u001d\u0003\u007f\u0001BAMA\u001e\u0015&\u0019\u0011QH\u001a\u0003\u000f\u0011\u000bG/Y:fi\"9\u0011\u0011I\u0006A\u0002\u0005\r\u0013A\u00013t!\u0011\u0011\u00141H\u0013")
public class DefaultValidHandler
implements ValidHandler<Object, LightMessage> {
    private final Logger logger = LoggerFactory.getLogger(DefaultValidHandler.class);

    private Logger logger() {
        return this.logger;
    }

    @Override
    public Tuple2<Object, LightMessage> valid(LightMessage message) {
        Tuple2 tuple2;
        try {
            GroupExtEntity groupEntity;
            block9: {
                block8: {
                    groupEntity = GroupDBWrapper.queryById((int)message.getGroupId());
                    if (groupEntity == null) break block8;
                    GroupStateEnum groupStateEnum = groupEntity.getState();
                    GroupStateEnum groupStateEnum2 = GroupStateEnum.RUNNING;
                    if (!(groupStateEnum == null ? groupStateEnum2 != null : !groupStateEnum.equals(groupStateEnum2))) break block9;
                }
                return null;
            }
            int threshold = this.getThreshold(groupEntity, LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING);
            if (!LimitingContext.getInstance().tryAcquire(groupEntity, threshold, message.getRepeat())) {
                this.logger().error(new StringBuilder(70).append("limited trigger strategy:GROUP_MESSAGE_SIZE_LIMIT,").append("group id:").append(groupEntity.getId()).append(",threshold:").append((long)threshold * 60L).toString());
                return null;
            }
            MessageCaptchaEnum resultCodeEnum = this.validMessage(message, groupEntity);
            SwitchStateEnum switchStateEnum = groupEntity.getDebugMode();
            SwitchStateEnum switchStateEnum2 = SwitchStateEnum.OPEN;
            if (!(switchStateEnum != null ? !switchStateEnum.equals(switchStateEnum2) : switchStateEnum2 != null)) {
                this.capture(Predef$.MODULE$.Integer2int(groupEntity.getId()), message);
            }
            if (this.logger().isTraceEnabled()) {
                this.logger().trace(new StringBuilder(47).append("The group of message matching is:").append(groupEntity.getId()).append(",valid result:").append(resultCodeEnum).toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)resultCodeEnum.getCaptcha()), (Object)message);
        }
        catch (Exception ex) {
            this.logger().error("valid message error!", (Throwable)ex);
            tuple2 = null;
        }
        return tuple2;
    }

    public int getThreshold(GroupExtEntity group, LimitingStrategyEnum strategy) {
        return Predef$.MODULE$.Integer2int(group.getExtendConfig().getLimitingConfig().getOrDefault(strategy, Predef$.MODULE$.int2Integer(-1)));
    }

    public void capture(int groupId, LightMessage message) {
        long batchTime = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
        String lockTrackKey = new StringBuilder(18).append("lock_group_track_").append(groupId).append("_").append(batchTime).toString();
        if (RedisLimitingAspect.getInstance().tryAcquire(lockTrackKey, 5, 50L, TimeUnit.MINUTES.toSeconds(5L), 1)) {
            String trackKey = new StringBuilder(12).append("group_track_").append(groupId).toString();
            message.setSystemTime(System.currentTimeMillis());
            if (this.logger().isTraceEnabled()) {
                this.logger().trace(new StringBuilder(42).append("group[").append(groupId).append("] enable debug mode,capture message:").append(JsonUtil.toJSONString((Object)message)).toString());
            }
            RedisClient.getInstance().limitSet(trackKey, JsonUtil.toJSONString((Object)message), 500, 7200);
            return;
        }
    }

    public MessageCaptchaEnum validMessage(LightMessage message, GroupExtEntity statGroup) {
        List columnList = statGroup.getColumns();
        if (!MessageValid.valid((int)Predef$.MODULE$.Integer2int(statGroup.getId()), (LightMessage)message, (List)columnList)) {
            return MessageCaptchaEnum.PARAM_CHECK_FAILED;
        }
        return MessageCaptchaEnum.SUCCESS;
    }

    public <A> Encoder<Tuple2<Object, LightMessage>> single(ClassTag<Tuple2<Object, LightMessage>> c) {
        return Encoders$.MODULE$.kryo(c);
    }

    public <A1, A2> Encoder<Tuple2<A1, A2>> tuple(Encoder<A1> e1, Encoder<A2> e2) {
        return Encoders$.MODULE$.tuple(e1, e2);
    }

    @Override
    public Dataset<Tuple2<Object, LightMessage>> valid(Dataset<LightMessage> ds) {
        return ds.map((Function1 & Serializable & scala.Serializable)x -> this.valid((LightMessage)x), this.single((ClassTag<Tuple2<Object, LightMessage>>)ClassTag$.MODULE$.apply(Tuple2.class))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DefaultValidHandler.$anonfun$valid$2(x)));
    }

    public static final /* synthetic */ boolean $anonfun$valid$2(Tuple2 x) {
        return x != null;
    }

    public DefaultValidHandler(SparkSession spark) {
    }
}

