/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.entity.group;

import com.dtstep.lighthouse.common.entity.stat.TimeParam;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.util.BeanCopyUtil;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GroupExtEntity
extends Group {
    private static final long serialVersionUID = -5705802803071692695L;
    private String verifyKey;
    private Map<String, ColumnTypeEnum> runningRelatedColumns;
    private Map<String, ColumnTypeEnum> allRelatedColumns;
    private boolean isBuiltIn = false;
    private TimeParam minTimeParam;
    private long dataExpire = TimeUnit.DAYS.toMillis(3L);

    public GroupExtEntity() {
    }

    public GroupExtEntity(Group groupEntity) {
        assert (groupEntity != null);
        BeanCopyUtil.copy(groupEntity, this);
    }

    public Map<String, ColumnTypeEnum> getRunningRelatedColumns() {
        return this.runningRelatedColumns;
    }

    public void setRunningRelatedColumns(Map<String, ColumnTypeEnum> runningRelatedColumns) {
        this.runningRelatedColumns = runningRelatedColumns;
    }

    public TimeParam getMinTimeParam() {
        return this.minTimeParam;
    }

    public void setMinTimeParam(TimeParam minTimeParam) {
        this.minTimeParam = minTimeParam;
    }

    public long getDataExpire() {
        return this.dataExpire;
    }

    public void setDataExpire(long dataExpire) {
        this.dataExpire = dataExpire;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.isBuiltIn = builtIn;
    }

    public String getVerifyKey() {
        return this.verifyKey;
    }

    public void setVerifyKey(String verifyKey) {
        this.verifyKey = verifyKey;
    }

    public Map<String, ColumnTypeEnum> getAllRelatedColumns() {
        return this.allRelatedColumns;
    }

    public void setAllRelatedColumns(Map<String, ColumnTypeEnum> allRelatedColumns) {
        this.allRelatedColumns = allRelatedColumns;
    }

    public static boolean isLimitedExpired(GroupExtEntity groupExtEntity) {
        return groupExtEntity.getState() == GroupStateEnum.LIMITING && (groupExtEntity.getLimitingParam() == null || groupExtEntity.getLimitingParam().getEndTime() < System.currentTimeMillis());
    }

    public static boolean isDebugModeExpired(GroupExtEntity groupExtEntity) {
        return groupExtEntity.getDebugMode() == SwitchStateEnum.OPEN && (groupExtEntity.getDebugParam() == null || groupExtEntity.getDebugParam().getEndTime() < System.currentTimeMillis());
    }
}

