/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.enums.formula;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum CharTypeEnum {
    LETTER(1, 1, "[a-zA-Z]"),
    NUMERIC(2, 1, "[0-9]"),
    SPOT(16, 1, "[.]"),
    POUND(13, 1, "[#]"),
    UNDERLINE(3, 1, "[_]"),
    COLON(32, 1, "[:]"),
    PERCENT(31, 1, "[%]"),
    AT(32, 1, "[@]"),
    SINGLE_QUOTATION(12, 1, "[']"),
    QUOTATION(13, 1, "[\"]"),
    CHINESE(14, 1, "[\\u4e00-\\u9fa5]"),
    LOGICAL(4, 2, "[&|!><=]"),
    CALCULATE(6, 2, "[\\+\\-\\*/]"),
    SEMICOLON(5, 3, "[;]"),
    LBRACKET(7, 4, "[(]"),
    RBRACKET(8, 4, "[)]"),
    DOLLAR(9, 1, "[$]"),
    LBRACE(10, 1, "[{]"),
    RBRACE(11, 1, "[}]"),
    COMMA(12, 6, "[,]"),
    LSQUARE_BRACKET(13, 7, "[\\[]"),
    RSQUARE_BRACKET(14, 7, "[\\]]"),
    SPACE(17, 9, "[ ]"),
    END(99, 99, "[\u0001]");

    private int type;
    private int level;
    private String reg;

    private CharTypeEnum(int type, int level, String reg) {
        this.type = type;
        this.level = level;
        this.reg = reg;
    }

    private CharTypeEnum(int type, int level) {
        this.type = type;
        this.level = level;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getReg() {
        return this.reg;
    }

    public void setReg(String reg) {
        this.reg = reg;
    }

    public static CharTypeEnum getCharTypeEnum(char c) {
        for (CharTypeEnum charTypeEnum : CharTypeEnum.values()) {
            String reg = charTypeEnum.getReg();
            Pattern p = Pattern.compile(reg);
            Matcher m = p.matcher(String.valueOf(c));
            if (!m.matches()) continue;
            return charTypeEnum;
        }
        return null;
    }
}

