/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.enums.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public enum RequestCodeEnum {
    SUCCESS("0", "Success"),
    SYSTEM_ERROR("ldp_i18n_common_1001", "\u7cfb\u7edf\u5f02\u5e38"),
    REQUEST_PARAM_MISSING("ldp_i18n_common_1002", "\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931"),
    PARAM_FORMAT_ERROR("ldp_i18n_common_1003", "\u53c2\u6570\u683c\u5f0f\u9519\u8bef"),
    ILLEGAL_PARAMS("ldp_i18n_common_1004", "\u53c2\u6570\u683c\u5f0f\u4e0d\u5408\u6cd5"),
    AUTHORITY_LIMIT("ldp_i18n_common_1005", "\u6743\u9650\u9650\u5236\u6267\u884c\u8be5\u64cd\u4f5c"),
    USER_LOGIN_FAILURE("ldp_i18n_user_login_1010", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"),
    USER_STATUS_NOT_AVAILABLE("ldp_i18n_user_login_1011", "\u8be5\u7528\u6237\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5ba1\u6838"),
    USER_REGISTER_USERNAME_EXIST("ldp_i18n_user_register_1015", "\u7528\u6237\u540d\u5df2\u5b58\u5728"),
    USER_PASSWORD_NOT_RIGHT("ldp_i18n_change_password_1011", "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef"),
    USER_ADMIN_USERNAME_UPDATE_ERROR("ldp_i18n_update_user_1014", "\u4e0d\u53ef\u4fee\u6539admin\u8d26\u6237\u7684\u7528\u6237\u540d"),
    UNAUTHORIZED_ACCESS("ldp_i18n_authorize_1007", "\u7cfb\u7edf\u8bbf\u95ee\u672a\u7ecf\u6388\u6743"),
    UNAUTHORIZED_ULIMIT_ACCESS("ldp_i18n_authorize_1008", "\u7cfb\u7edf\u6388\u6743\u53d7\u9650\uff0c\u6ce8\u518c\u7528\u6237\u6570\u8d85\u51fa\u9650\u5236"),
    AUTHORIZE_FAILED("ldp_i18n_authorize_1009", "\u7cfb\u7edf\u6388\u6743\u5931\u8d25\uff0c\u6ce8\u518c\u7801\u9519\u8bef"),
    DEPARTMENT_DELETE_HAS_CHILD_NODE("ldp_i18n_department_delete_1004", "\u8be5\u90e8\u95e8\u4e0b\u9762\u6709\u5b50\u90e8\u95e8\u4e0d\u53ef\u5220\u9664"),
    DEPARTMENT_ID_NOT_EXIST("ldp_i18n_department_update_1010", "\u90e8\u95e8ID\u4e0d\u5b58\u5728"),
    DEPARTMENT_ADD_PID_NOT_EXIST("ldp_i18n_department_create_1009", "\u90e8\u95e8PID\u4e0d\u5b58\u5728"),
    DEPARTMENT_ADD_NAME_EXIST("ldp_i18n_department_create_1010", "\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728"),
    DEPARTMENT_LIMIT_MAX_LEVEL("ldp_i18n_department_create_1011", "\u90e8\u95e8\u5c42\u7ea7\u6700\u5927\u9650\u5236"),
    DEPARTMENT_DELETE_HAS_STAT_PROJECT("ldp_i18n_department_delete_1005", "\u8be5\u90e8\u95e8\u4e0b\u9762\u6709\u7edf\u8ba1\u5de5\u7a0b\u4e0d\u53ef\u5220\u9664"),
    DEPARTMENT_DELETE_HAS_USER("ldp_i18n_department_delete_1006", "\u8be5\u90e8\u95e8\u4e0b\u9762\u6709\u7528\u6237\u4e0d\u53ef\u5220\u9664"),
    PROJECT_NAME_ALREADY_EXIST("ldp_i18n_project_create_1023", "\u7edf\u8ba1\u5de5\u7a0b\u540d\u79f0\u5df2\u5b58\u5728"),
    PROJECT_ID_NOT_EXIST("ldp_i18n_project_create_1024", "\u7edf\u8ba1\u5de5\u7a0bID\u4e0d\u5b58\u5728"),
    PROJECT_NOT_HAS_STAT_ITEM("ldp_i18n_project_list_1017", "\u8be5\u7edf\u8ba1\u5de5\u7a0b\u4e0b\u6ca1\u6709\u7edf\u8ba1\u9879\u5b58\u5728"),
    PROJECT_HAVE_STAT_GROUP("ldp_i18n_project_delete_1001", "\u8be5\u7edf\u8ba1\u5de5\u7a0b\u4e0b\u6709\u7edf\u8ba1\u7ec4\u5b58\u5728"),
    GROUP_HAVE_STAT_ITEM("ldp_i18n_group_delete_1001", "\u8be5\u7edf\u8ba1\u7ec4\u4e0b\u6709\u7edf\u8ba1\u4efb\u52a1\u5b58\u5728"),
    GROUP_ITEMS_EXCEEDS_LIMIT("ldp_i18n_group_create_1043", "\u7edf\u8ba1\u9879\u6570\u91cf\u8d85\u51fa\u7edf\u8ba1\u7ec4\u9650\u5236"),
    GROUP_TOKEN_EXIST("ldp_i18n_group_create_1044", "\u7edf\u8ba1\u7ec4Token\u5df2\u5b58\u5728"),
    GROUP_COLUMN_PROHIBITED("ldp_i18n_group_create_1045", "\u7981\u6b62\u4f7f\u7528\u5b57\u6bb5\u540d\u3010%s\u3011"),
    TEMPLATE_FORMAT_ERROR("ldp_i18n_group_create_1046", "\u7edf\u8ba1\u9879\u914d\u7f6e\u89e3\u6790\u9519\u8bef"),
    STAT_AT_LEAST_ONE("ldp_i18n_group_create_1047", "\u7edf\u8ba1\u9879\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a"),
    APPLY_NOT_SUPPORT("ldp_i18n_privilege_apply_1023", "\u4e0d\u652f\u6301\u8be5\u6743\u9650\u7c7b\u578b\u7533\u8bf7"),
    APPLY_HAS_ROLE_ALREADY("ldp_i18n_privilege_apply_1024", "\u5df2\u7ecf\u6709\u8be5\u6743\u9650\uff0c\u4e0d\u53ef\u91cd\u590d\u7533\u8bf7"),
    APPLY_NOT_SUPPORT_RETRACT("ldp_i18n_privilege_apply_1025", "\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u64a4\u56de"),
    RELATIONS_EXCEED_LIMIT("ldp_i18n_favorite_stat_1004", "\u6536\u85cf\u6570\u91cf\u8d85\u51fa\u9650\u5236"),
    APPROVE_NOT_AUTHORITY("ldp_i18n_privilege_approve_1011", "\u4e0d\u5177\u6709\u5ba1\u6279\u6743\u9650"),
    COLUMN_NAME_NOT_EXIST("ldp_i18n_display_1001", "\u5b57\u6bb5\u540d\u3010%s\u3011\u4e0d\u5b58\u5728"),
    COLUMN_NAME_DUPLICATE("ldp_i18n_display_1002", "\u7b5b\u9009\u53c2\u6570\u3010%s\u3011\u91cd\u590d"),
    NO_FILTER_PARAMS_SELECTED("ldp_i18n_display_1003", "\u8be5\u7edf\u8ba1\u9879\u6ca1\u6709\u53ef\u9009\u62e9\u7684\u7b5b\u9009\u53c2\u6570"),
    DISPLAY_NOT_MATCH_STAT("ldp_i18n_display_1004", "\u6682\u65e0\u6570\u636e\uff0c\u6ca1\u6709\u5339\u914d\u7684\u7edf\u8ba1\u9879\u3010dimens\uff1a%s\u3011"),
    DISPLAY_QUERY_RESULT_EXCEED_LIMIT("ldp_i18n_display_1005", "\u5355\u6b21\u67e5\u8be2\u7ed3\u679c\u91cf\u8d85\u51fa\u9650\u5236"),
    DISPLAY_QUERY_DIMENS_EXCEED_LIMIT("ldp_i18n_display_1006", "\u5355\u6b21\u67e5\u8be2\u7ef4\u5ea6\u6570\u91cf\u8d85\u51fa\u9650\u5236"),
    DISPLAY_EXPORT_RESULT_EXCEED_LIMIT("ldp_i18n_display_1007", "\u5355\u6b21\u5bfc\u51fa\u7ed3\u679c\u91cf\u8d85\u51fa\u9650\u5236"),
    SITEMAP_STRUCT_EMPTY("ldp_i18n_sitemap_manage_1010", "\u6570\u636e\u5730\u56fe\u7ed3\u6784\u4e0d\u53ef\u4e3a\u7a7a"),
    SITEMAP_NODES_EXCEED_LIMIT("ldp_i18n_sitemap_manage_1031", "\u6811\u7ed3\u6784\u8282\u70b9\u6570\u8d85\u51fa\u6700\u5927\u9650\u5236"),
    SITEBIND_ALREADY_EXIST("ldp_i18n_sitebind_update_1007", "\u6570\u636e\u5730\u56fe\u7ed1\u5b9a\u5173\u7cfb\u5df2\u5b58\u5728");

    private String code;
    private String msg;

    private RequestCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static ObjectNode toJSON(Exception ex) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("code", "-1");
        objectNode.put("msg", ex.getLocalizedMessage());
        return objectNode;
    }

    public static ObjectNode toJSON(RequestCodeEnum requestCodeEnum) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("code", requestCodeEnum.getCode());
        objectNode.put("msg", String.format("i18n(%s)", requestCodeEnum.getCode()));
        return objectNode;
    }

    public static ObjectNode toJSON(RequestCodeEnum requestCodeEnum, String params) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("code", requestCodeEnum.getCode());
        objectNode.put("msg", String.format("i18n(%s,%s)", requestCodeEnum.getCode(), params));
        return objectNode;
    }

    public static ObjectNode toJSON(String msg) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("code", "-1");
        try {
            objectNode.put("msg", msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objectNode;
    }
}

