/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class LongListHelper {
    public static void write(OutputStream ostr, List<Long> v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.size());
            for (long elem : v) {
                ostr.writeLong(elem);
            }
        }
    }

    public static List<Long> read(InputStream istr) {
        ArrayList<Long> v = new ArrayList<Long>();
        int len0 = istr.readAndCheckSeqSize(8);
        for (int i0 = 0; i0 < len0; ++i0) {
            long elem = istr.readLong();
            v.add(elem);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<List<Long>> v) {
        if (v != null && v.isPresent()) {
            LongListHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, List<Long> v) {
        if (ostr.writeOptional(tag, OptionalFormat.VSize)) {
            int optSize = v == null ? 0 : v.size();
            ostr.writeSize(optSize > 254 ? optSize * 8 + 5 : optSize * 8 + 1);
            LongListHelper.write(ostr, v);
        }
    }

    public static Optional<List<Long>> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.VSize)) {
            istr.skipSize();
            List<Long> v = LongListHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

