/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.ice;

import com.dtstep.lighthouse.common.ice.LightRpcException;
import com.dtstep.lighthouse.common.ice.LongListHelper;
import com.dtstep.lighthouse.common.ice.StringListHelper;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;

public interface RemoteLightServer
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public byte[] process(byte[] var1, Current var2) throws LightRpcException;

    public byte[] queryGroupInfo(String var1, Current var2) throws LightRpcException;

    public byte[] queryStatInfo(int var1, Current var2) throws LightRpcException;

    public byte[] dataDurationQuery(int var1, String var2, long var3, long var5, Current var7) throws LightRpcException;

    public byte[] dataQuery(int var1, String var2, List<Long> var3, Current var4) throws LightRpcException;

    public byte[] dataDurationQueryWithDimensList(int var1, List<String> var2, long var3, long var5, Current var7) throws LightRpcException;

    public byte[] dataQueryWithDimensList(int var1, List<String> var2, List<Long> var3, Current var4) throws LightRpcException;

    public byte[] limitQuery(int var1, long var2, Current var4) throws LightRpcException;

    public byte[] dataDurationQueryV2(String var1, String var2, int var3, String var4, long var5, long var7, Current var9) throws LightRpcException;

    public byte[] dataQueryV2(String var1, String var2, int var3, String var4, List<Long> var5, Current var6) throws LightRpcException;

    public byte[] dataDurationQueryWithDimensListV2(String var1, String var2, int var3, List<String> var4, long var5, long var7, Current var9) throws LightRpcException;

    public byte[] dataQueryWithDimensListV2(String var1, String var2, int var3, List<String> var4, List<Long> var5, Current var6) throws LightRpcException;

    public byte[] limitQueryV2(String var1, String var2, int var3, long var4, Current var6) throws LightRpcException;

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return RemoteLightServer.ice_staticId();
    }

    public static String ice_staticId() {
        return "::LightServer::RemoteLightServer";
    }

    public static CompletionStage<OutputStream> _iceD_process(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        byte[] iceP_message = istr.readByteSeq();
        inS.endReadParams();
        byte[] ret = obj.process(iceP_message, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_queryGroupInfo(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_token = istr.readString();
        inS.endReadParams();
        byte[] ret = obj.queryGroupInfo(iceP_token, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_queryStatInfo(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_id = istr.readInt();
        inS.endReadParams();
        byte[] ret = obj.queryStatInfo(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataDurationQuery(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_statId = istr.readInt();
        String iceP_dimensValue = istr.readString();
        long iceP_startTime = istr.readLong();
        long iceP_endTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.dataDurationQuery(iceP_statId, iceP_dimensValue, iceP_startTime, iceP_endTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataQuery(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_statId = istr.readInt();
        String iceP_dimensValue = istr.readString();
        List<Long> iceP_batchList = LongListHelper.read(istr);
        inS.endReadParams();
        byte[] ret = obj.dataQuery(iceP_statId, iceP_dimensValue, iceP_batchList, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataDurationQueryWithDimensList(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_statId = istr.readInt();
        List<String> iceP_dimensValueList = StringListHelper.read(istr);
        long iceP_startTime = istr.readLong();
        long iceP_endTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.dataDurationQueryWithDimensList(iceP_statId, iceP_dimensValueList, iceP_startTime, iceP_endTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataQueryWithDimensList(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_statId = istr.readInt();
        List<String> iceP_dimensValueList = StringListHelper.read(istr);
        List<Long> iceP_batchList = LongListHelper.read(istr);
        inS.endReadParams();
        byte[] ret = obj.dataQueryWithDimensList(iceP_statId, iceP_dimensValueList, iceP_batchList, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_limitQuery(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_statId = istr.readInt();
        long iceP_batchTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.limitQuery(iceP_statId, iceP_batchTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataDurationQueryV2(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_callerName = istr.readString();
        String iceP_callerKey = istr.readString();
        int iceP_statId = istr.readInt();
        String iceP_dimensValue = istr.readString();
        long iceP_startTime = istr.readLong();
        long iceP_endTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.dataDurationQueryV2(iceP_callerName, iceP_callerKey, iceP_statId, iceP_dimensValue, iceP_startTime, iceP_endTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataQueryV2(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_callerName = istr.readString();
        String iceP_callerKey = istr.readString();
        int iceP_statId = istr.readInt();
        String iceP_dimensValue = istr.readString();
        List<Long> iceP_batchList = LongListHelper.read(istr);
        inS.endReadParams();
        byte[] ret = obj.dataQueryV2(iceP_callerName, iceP_callerKey, iceP_statId, iceP_dimensValue, iceP_batchList, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataDurationQueryWithDimensListV2(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_callerName = istr.readString();
        String iceP_callerKey = istr.readString();
        int iceP_statId = istr.readInt();
        List<String> iceP_dimensValueList = StringListHelper.read(istr);
        long iceP_startTime = istr.readLong();
        long iceP_endTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.dataDurationQueryWithDimensListV2(iceP_callerName, iceP_callerKey, iceP_statId, iceP_dimensValueList, iceP_startTime, iceP_endTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_dataQueryWithDimensListV2(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_callerName = istr.readString();
        String iceP_callerKey = istr.readString();
        int iceP_statId = istr.readInt();
        List<String> iceP_dimensValueList = StringListHelper.read(istr);
        List<Long> iceP_batchList = LongListHelper.read(istr);
        inS.endReadParams();
        byte[] ret = obj.dataQueryWithDimensListV2(iceP_callerName, iceP_callerKey, iceP_statId, iceP_dimensValueList, iceP_batchList, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_limitQueryV2(RemoteLightServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_callerName = istr.readString();
        String iceP_callerKey = istr.readString();
        int iceP_statId = istr.readInt();
        long iceP_batchTime = istr.readLong();
        inS.endReadParams();
        byte[] ret = obj.limitQueryV2(iceP_callerName, iceP_callerKey, iceP_statId, iceP_batchTime, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return RemoteLightServer._iceD_dataDurationQuery(this, in, current);
            }
            case 1: {
                return RemoteLightServer._iceD_dataDurationQueryV2(this, in, current);
            }
            case 2: {
                return RemoteLightServer._iceD_dataDurationQueryWithDimensList(this, in, current);
            }
            case 3: {
                return RemoteLightServer._iceD_dataDurationQueryWithDimensListV2(this, in, current);
            }
            case 4: {
                return RemoteLightServer._iceD_dataQuery(this, in, current);
            }
            case 5: {
                return RemoteLightServer._iceD_dataQueryV2(this, in, current);
            }
            case 6: {
                return RemoteLightServer._iceD_dataQueryWithDimensList(this, in, current);
            }
            case 7: {
                return RemoteLightServer._iceD_dataQueryWithDimensListV2(this, in, current);
            }
            case 8: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 9: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 10: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 11: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
            case 12: {
                return RemoteLightServer._iceD_limitQuery(this, in, current);
            }
            case 13: {
                return RemoteLightServer._iceD_limitQueryV2(this, in, current);
            }
            case 14: {
                return RemoteLightServer._iceD_process(this, in, current);
            }
            case 15: {
                return RemoteLightServer._iceD_queryGroupInfo(this, in, current);
            }
            case 16: {
                return RemoteLightServer._iceD_queryStatInfo(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::LightServer::RemoteLightServer"};
        _iceOps = new String[]{"dataDurationQuery", "dataDurationQueryV2", "dataDurationQueryWithDimensList", "dataDurationQueryWithDimensListV2", "dataQuery", "dataQueryV2", "dataQueryWithDimensList", "dataQueryWithDimensListV2", "ice_id", "ice_ids", "ice_isA", "ice_ping", "limitQuery", "limitQueryV2", "process", "queryGroupInfo", "queryStatInfo"};
    }
}

