/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.lru;

import com.dtstep.lighthouse.common.lru.Cache;
import com.dtstep.lighthouse.common.lru.impl.LDPCache;
import java.util.concurrent.TimeUnit;

public final class LRU<K, V> {
    private long expireAfterWriteSeconds = -1L;
    private long expireAfterAccessSeconds = -1L;
    private long maximumSize = 300L;
    private boolean softValues = true;

    public long getExpireAfterWriteSeconds() {
        return this.expireAfterWriteSeconds;
    }

    public void setExpireAfterWriteSeconds(long expireAfterWriteSeconds) {
        this.expireAfterWriteSeconds = expireAfterWriteSeconds;
    }

    public long getExpireAfterAccessSeconds() {
        return this.expireAfterAccessSeconds;
    }

    public void setExpireAfterAccessSeconds(long expireAfterAccessSeconds) {
        this.expireAfterAccessSeconds = expireAfterAccessSeconds;
    }

    public boolean isSoftValues() {
        return this.softValues;
    }

    public void setSoftValues(boolean softValues) {
        this.softValues = softValues;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public static LRU<Object, Object> newBuilder() {
        return new LRU<Object, Object>();
    }

    private LRU() {
    }

    public LRU<K, V> expireAfterWrite(long interval, TimeUnit unit) {
        this.expireAfterWriteSeconds = unit.toSeconds(interval);
        return this;
    }

    public LRU<K, V> expireAfterAccess(long interval, TimeUnit unit) {
        this.expireAfterAccessSeconds = unit.toSeconds(interval);
        return this;
    }

    public LRU<K, V> maximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public LRU<K, V> softValues() {
        this.softValues = true;
        return this;
    }

    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        return new LDPCache(this);
    }
}

