/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.rpc.netty;

import com.dtstep.lighthouse.common.entity.rpc.RpcMsgType;
import com.dtstep.lighthouse.common.entity.rpc.RpcResponse;
import com.dtstep.lighthouse.common.rpc.netty.ProcessedFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        String requestId;
        CompletableFuture<RpcResponse<?>> completableFuture;
        RpcResponse response;
        if (msg instanceof RpcResponse && (response = (RpcResponse)msg).getType() == RpcMsgType.Normal && (completableFuture = ProcessedFuture.remove(requestId = response.getRequestId())) != null) {
            completableFuture.complete(response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

