/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.serializer;

import com.dtstep.lighthouse.common.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;

public class JDKSerializer
implements Serializer {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> byte[] serialize(T obj) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(obj);
                oos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to serialize object!", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            T t;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                t = clazz.cast(ois.readObject());
            }
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to deserialize object!", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> byte[] serializerList(List<T> list) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(list);
                oos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to serialize list object!", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> deserializeList(byte[] bytes, Class<T> clazz) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            List list;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                list = (List)ois.readObject();
            }
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to deserialize list object!", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> byte[] serializerMap(Map<K, V> map) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(map);
                oos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to serialize list object!", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> Map<K, V> deserializeMap(byte[] bytes, Class<? extends Map> clazz) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Map map;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                map = (Map)ois.readObject();
            }
            return map;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to deserialize list object!", ex);
        }
    }
}

