/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class AesUtil {
    private static final String IV = "e4883f3c48f6e8867265cdbc75b948aa";
    private static final String SALT = "fb1837e8d99840b70d91295965851835";
    private final int keySize;
    private final int iterationCount;
    private final Cipher cipher;

    public AesUtil(int keySize, int iterationCount) {
        this.keySize = keySize;
        this.iterationCount = iterationCount;
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw this.fail(e);
        }
    }

    public String encrypt(String passphrase, String plaintext) throws Exception {
        SecretKey key = this.generateKey(passphrase);
        byte[] encrypted = this.doFinal(1, key, IV, plaintext.getBytes("UTF-8"));
        return AesUtil.base64(encrypted);
    }

    public String decrypt(String passphrase, String ciphertext) throws Exception {
        SecretKey key = this.generateKey(passphrase);
        byte[] decrypted = this.doFinal(2, key, IV, AesUtil.base64(ciphertext));
        return new String(decrypted, "UTF-8");
    }

    private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes) {
        try {
            this.cipher.init(encryptMode, (Key)key, new IvParameterSpec(AesUtil.hex(iv)));
            return this.cipher.doFinal(bytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            return null;
        }
    }

    private SecretKey generateKey(String passphrase) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), AesUtil.hex(SALT), this.iterationCount, this.keySize);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }

    private static String random(int length) {
        byte[] salt = new byte[length];
        new SecureRandom().nextBytes(salt);
        return AesUtil.hex(salt);
    }

    private static String base64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    private static byte[] base64(String str) {
        return Base64.decodeBase64((String)str);
    }

    private static String hex(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    private static byte[] hex(String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private IllegalStateException fail(Exception e) {
        return null;
    }
}

