/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpUtil {
    public static boolean isUrlReachable(String urlString) {
        return HttpUtil.isReachableWithMethod(urlString, "HEAD") || HttpUtil.isReachableWithMethod(urlString, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isReachableWithMethod(String urlString, String method) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setInstanceFollowRedirects(true);
            int responseCode = connection.getResponseCode();
            boolean bl = responseCode >= 200 && responseCode < 400;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

