/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtil.class);
    public static final String DOT = ".";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";

    private ReflectUtil() {
    }

    public static void close(Object object) {
        try {
            ReflectUtil.invoke(object, "close");
        }
        catch (Exception var2) {
            logger.warn(var2.getMessage(), (Throwable)var2);
        }
    }

    public static void dispose(Object object) {
        try {
            ReflectUtil.invoke(object, "dispose");
        }
        catch (Exception var2) {
            logger.warn(var2.getMessage(), (Throwable)var2);
        }
    }

    public static <T> T run(Object object, String methodName) {
        T result = null;
        try {
            result = ReflectUtil.invoke(object, methodName);
        }
        catch (Exception var4) {
            logger.warn(var4.getMessage(), (Throwable)var4);
        }
        return result;
    }

    public static <T> T run(Object object, String methodName, Object[] args) {
        T result = null;
        try {
            result = ReflectUtil.invoke(object, methodName, args);
        }
        catch (Exception var5) {
            logger.warn(var5.getMessage(), (Throwable)var5);
        }
        return result;
    }

    public static <T> T run(Object object, String methodName, Object[] args, Class<?>[] argsType) {
        T result = null;
        try {
            result = ReflectUtil.invoke(object, methodName, args, argsType);
        }
        catch (Exception var6) {
            logger.warn(var6.getMessage(), (Throwable)var6);
        }
        return result;
    }

    public static <T> T getValue(Object object, String name) {
        if (name.endsWith("()")) {
            name = name.replace("()", "");
            return ReflectUtil.getMethodValue(object, name);
        }
        return ReflectUtil.getFieldValue(object, name);
    }

    public static <T> T getFieldValue(Object object, String fieldName) {
        try {
            Field e = ReflectUtil.getField(object.getClass(), fieldName);
            if (e != null) {
                return (T)e.get(object);
            }
        }
        catch (Exception var3) {
            logger.warn(var3.getMessage(), (Throwable)var3);
        }
        return null;
    }

    private static <T> T getMethodValue(Object object, String methodName) {
        try {
            return ReflectUtil.invoke(object, methodName);
        }
        catch (Exception var3) {
            logger.warn(var3.getMessage(), (Throwable)var3);
            return null;
        }
    }

    public static <T> T invoke(Object object, String methodName) {
        if (object == null) {
            return null;
        }
        try {
            Method e = ReflectUtil.getMethod(object.getClass(), methodName, new Class[0]);
            return (T)(e != null ? e.invoke(object, new Object[0]) : null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T invoke(Object object, String methodName, Object[] args) {
        if (args != null && args.length != 0) {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            return ReflectUtil.invoke(object, methodName, args, argTypes);
        }
        return ReflectUtil.invoke(object, methodName);
    }

    public static <T> T invoke(Object object, String methodName, Object[] args, Class<?>[] argTypes) {
        if (object == null) {
            return null;
        }
        try {
            Method e = ReflectUtil.getMethod(object.getClass(), methodName, argTypes);
            return (T)(e != null ? e.invoke(object, args) : null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException var6) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException var5) {
                if (clazz.getSuperclass() == null) {
                    return field;
                }
                return ReflectUtil.getField(clazz.getSuperclass(), fieldName);
            }
        }
        field.setAccessible(true);
        return field;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... argsType) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, argsType);
        }
        catch (NoSuchMethodException var7) {
            try {
                method = clazz.getDeclaredMethod(methodName, argsType);
            }
            catch (NoSuchMethodException var6) {
                if (clazz.getSuperclass() == null) {
                    return method;
                }
                return ReflectUtil.getMethod(clazz.getSuperclass(), methodName, argsType);
            }
        }
        method.setAccessible(true);
        return method;
    }

    public static Class<?>[] getClassOfArgs(Object ... args) {
        Class[] types = new Class[args.length];
        int i = -1;
        for (Object argv : args) {
            types[++i] = argv.getClass();
        }
        return types;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

