/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.client;

import com.dtstep.lighthouse.client.Consumer;
import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.client.rpc.RPCClientProxy;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.enums.fusing.FusingRules;
import com.dtstep.lighthouse.common.fusing.FusingSwitch;
import com.dtstep.lighthouse.common.fusing.FusingToken;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.util.StopWatch;
import com.zeroc.Ice.NotRegisteredException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DelayRunnable
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Consumer.class);
    private final EventPool<SimpleSlotEvent> eventPool;
    private final int batchSize;
    private static final long timeThreshold = TimeUnit.SECONDS.toMillis(1L);

    DelayRunnable(EventPool<SimpleSlotEvent> eventPool, int batchSize) {
        this.setDaemon(true);
        this.eventPool = eventPool;
        this.batchSize = batchSize;
    }

    @Override
    public void run() {
        IntStream.range(0, this.eventPool.slotSize()).forEach(this::consumer);
    }

    public void consumer(int slot) {
        try {
            SlotsGroup.SlotWrapper<SimpleSlotEvent> slotWrapper = this.eventPool.take(slot);
            StringBuilder sbr = StringBuilderHolder.Bigger.getStringBuilder();
            while ((double)slotWrapper.size() >= (double)this.batchSize * 3.0 || System.currentTimeMillis() - slotWrapper.getLastAccessTime() > timeThreshold) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                List<SimpleSlotEvent> events = slotWrapper.getEvents(this.batchSize);
                if (!events.isEmpty()) {
                    Map<String, Long> counterMap = events.stream().collect(Collectors.groupingBy(SimpleSlotEvent::getMessage, Collectors.summingLong(SimpleSlotEvent::getRepeat)));
                    Iterator<Map.Entry<String, Long>> iterator2 = counterMap.entrySet().iterator();
                    int i = 0;
                    while (iterator2.hasNext()) {
                        Map.Entry<String, Long> entry = iterator2.next();
                        if (i != 0) {
                            sbr.append("\u0003");
                        }
                        sbr.append(entry.getKey()).append("\u0004").append(entry.getValue());
                        ++i;
                    }
                    this.send(sbr.toString());
                    sbr.setLength(0);
                    if (logger.isDebugEnabled()) {
                        logger.debug("process client message,thread:{},slot:{},process size:{},remaining size:{},capacity:{},accessTime:{},cost:{}ms", new Object[]{Thread.currentThread().getName(), slot, events.size(), slotWrapper.size(), slotWrapper.getCapacity(), slotWrapper.getLastAccessTime(), stopWatch.getTime()});
                    }
                    events.clear();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("lighthouse send client messages error!", (Throwable)ex);
        }
    }

    public void send(String text) {
        FusingToken fusingToken = null;
        try {
            fusingToken = FusingSwitch.entry(FusingRules.CLIENT_EXCEPTION_RULE);
            if (fusingToken == null) {
                logger.error("number of exceptions reaches the threshold, the call is blocked!");
                return;
            }
            RPCClientProxy.instance().send(text);
        }
        catch (NotRegisteredException ex) {
            LightHouse._InitFlag.set(false);
            logger.error("lighthouse client failed to send message!", (Throwable)ex);
            FusingSwitch.track(fusingToken);
        }
        catch (Exception ex) {
            logger.error("lighthouse client failed to send message!", (Throwable)ex);
            FusingSwitch.track(fusingToken);
        }
    }
}

