/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.client.rpc.ice;

import com.dtstep.lighthouse.client.rpc.RPCClient;
import com.dtstep.lighthouse.client.rpc.ice.ICEHandler;
import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.exception.InitializationException;
import com.dtstep.lighthouse.common.ice.RemoteLightServerPrx;
import com.dtstep.lighthouse.common.serializer.SerializerProxy;
import com.dtstep.lighthouse.common.util.SnappyUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICERPCClientImpl
implements RPCClient {
    private static final Logger logger = LoggerFactory.getLogger(ICERPCClientImpl.class);
    private static Communicator ic;

    @Override
    public boolean init(String locators) throws Exception {
        if (StringUtil.isEmpty(locators)) {
            throw new InitializationException("lighthouse client init failed,locators cannot be empty!");
        }
        StringBuilder locatorSbr = new StringBuilder();
        try {
            String[] locatorArr;
            for (String conf : locatorArr = locators.split(",")) {
                String[] arr = conf.split(":");
                String ip = arr[0];
                String port = arr[1];
                locatorSbr.append(":").append("tcp -h ").append(ip).append(" -p ").append(port);
            }
        }
        catch (Exception ex) {
            throw new InitializationException("lighthouse client init failed,locators format error!");
        }
        try {
            String cfg = String.format("--Ice.Default.Locator=LightHouseIceGrid/Locator %s -z", locatorSbr.toString());
            String[] initParams = new String[]{cfg};
            Properties iceProperties = Util.createProperties();
            iceProperties.setProperty("Ice.Override.ConnectTimeout", "5000");
            iceProperties.setProperty("Ice.RetryIntervals", "20");
            iceProperties.setProperty("Ice.ThreadPool.Client.Size", "50");
            iceProperties.setProperty("Ice.ThreadPool.Client.SizeMax", "300");
            iceProperties.setProperty("Ice.MessageSizeMax", "1409600");
            InitializationData initData = new InitializationData();
            initData.properties = iceProperties;
            ic = Util.initialize(initParams, initData);
            RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
            remoteLightServerPrx.ice_ping();
            logger.info("lighthouse client init success!");
        }
        catch (Exception ex) {
            throw new InitializationException(String.format("lighthouse remote service not available,locators:%s", locators));
        }
        return true;
    }

    @Override
    public void send(String text) throws Exception {
        byte[] bytes = text.length() < 256 ? text.getBytes(StandardCharsets.UTF_8) : SnappyUtil.compressToByte(text);
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        remoteLightServerPrx.process(bytes);
    }

    @Override
    public GroupVerifyEntity queryGroupInfo(String token) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.queryGroupInfo(token);
        GroupVerifyEntity groupVerifyEntity = null;
        if (bytes != null && bytes.length > 0) {
            groupVerifyEntity = SerializerProxy.instance().deserialize(bytes, GroupVerifyEntity.class);
        }
        return groupVerifyEntity;
    }

    @Override
    public StatVerifyEntity queryStatInfo(int id) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.queryStatInfo(id);
        StatVerifyEntity statVerifyEntity = null;
        if (bytes != null && bytes.length > 0) {
            statVerifyEntity = SerializerProxy.instance().deserialize(bytes, StatVerifyEntity.class);
        }
        return statVerifyEntity;
    }

    @Override
    public List<StatValue> dataQuery(int statId, String dimensValue, List<Long> batchList) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataQuery(statId, dimensValue, batchList);
        List<StatValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, StatValue.class);
        }
        return valueList;
    }

    @Override
    public List<StatValue> dataDurationQuery(int statId, String dimensValue, long startTime, long endTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataDurationQuery(statId, dimensValue, startTime, endTime);
        List<StatValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, StatValue.class);
        }
        return valueList;
    }

    @Override
    public Map<String, List<StatValue>> dataQueryWithDimensList(int statId, List<String> dimensValueList, List<Long> batchList) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataQueryWithDimensList(statId, dimensValueList, batchList);
        Map data = null;
        if (bytes != null && bytes.length > 0) {
            data = SerializerProxy.instance().deserializeMap(bytes, HashMap.class);
        }
        return data;
    }

    @Override
    public Map<String, List<StatValue>> dataDurationQueryWithDimensList(int statId, List<String> dimensValueList, long startTime, long endTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataDurationQueryWithDimensList(statId, dimensValueList, startTime, endTime);
        Map data = null;
        if (bytes != null && bytes.length > 0) {
            data = SerializerProxy.instance().deserializeMap(bytes, HashMap.class);
        }
        return data;
    }

    @Override
    public List<LimitValue> limitQuery(int statId, long batchTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.limitQuery(statId, batchTime);
        List<LimitValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, LimitValue.class);
        }
        return valueList;
    }

    @Override
    public List<StatValue> dataQueryV2(String callerName, String callerKey, int statId, String dimensValue, List<Long> batchList) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataQueryV2(callerName, callerKey, statId, dimensValue, batchList);
        List<StatValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, StatValue.class);
        }
        return valueList;
    }

    @Override
    public List<StatValue> dataDurationQueryV2(String callerName, String callerKey, int statId, String dimensValue, long startTime, long endTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataDurationQueryV2(callerName, callerKey, statId, dimensValue, startTime, endTime);
        List<StatValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, StatValue.class);
        }
        return valueList;
    }

    @Override
    public Map<String, List<StatValue>> dataQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, List<Long> batchList) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataQueryWithDimensListV2(callerName, callerKey, statId, dimensValueList, batchList);
        Map data = null;
        if (bytes != null && bytes.length > 0) {
            data = SerializerProxy.instance().deserializeMap(bytes, HashMap.class);
        }
        return data;
    }

    @Override
    public Map<String, List<StatValue>> dataDurationQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, long startTime, long endTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.dataDurationQueryWithDimensListV2(callerName, callerKey, statId, dimensValueList, startTime, endTime);
        Map data = null;
        if (bytes != null && bytes.length > 0) {
            data = SerializerProxy.instance().deserializeMap(bytes, HashMap.class);
        }
        return data;
    }

    @Override
    public List<LimitValue> limitQueryV2(String callerName, String callerKey, int statId, long batchTime) throws Exception {
        RemoteLightServerPrx remoteLightServerPrx = ICEHandler.getRemotePrx(ic);
        byte[] bytes = remoteLightServerPrx.limitQueryV2(callerName, callerKey, statId, batchTime);
        List<LimitValue> valueList = null;
        if (bytes != null && bytes.length > 0) {
            valueList = SerializerProxy.instance().deserializeList(bytes, LimitValue.class);
        }
        return valueList;
    }

    @Override
    public void reconnect() throws Exception {
    }
}

