/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.counter;

import com.dtstep.lighthouse.common.lru.Cache;
import com.dtstep.lighthouse.common.lru.LRU;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class CycleCounterAdvisor {
    private static final Cache<String, LongAdder> counterCache = LRU.newBuilder().maximumSize(500000L).expireAfterAccess(3L, TimeUnit.MINUTES).softValues().build();

    public static long incrementAndGet(String symbol, long windowTime) {
        String counterKey = symbol + "_" + windowTime;
        LongAdder longAdder = counterCache.get(counterKey, k -> new LongAdder());
        longAdder.increment();
        return longAdder.longValue();
    }

    public static void increment(String symbol, long windowTime) {
        String counterKey = symbol + "_" + windowTime;
        LongAdder longAdder = counterCache.get(counterKey, k -> new LongAdder());
        longAdder.increment();
    }

    public static long getValue(String symbol, long windowTime) {
        String counterKey = symbol + "_" + windowTime;
        LongAdder longAdder = counterCache.get(counterKey, k -> new LongAdder());
        return longAdder.longValue();
    }
}

