/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.fusing;

import com.dtstep.lighthouse.common.counter.CycleCounterAdvisor;
import com.dtstep.lighthouse.common.enums.fusing.FusingRules;
import com.dtstep.lighthouse.common.exception.BlockException;
import com.dtstep.lighthouse.common.fusing.FusingToken;
import com.dtstep.lighthouse.common.util.DateUtil;

public final class FusingSwitch {
    public static FusingToken entry(FusingRules fusingRule) throws BlockException {
        long windowTime = DateUtil.batchTime(fusingRule.getDuration(), fusingRule.getTimeUnit(), System.currentTimeMillis());
        long failSize = CycleCounterAdvisor.getValue(fusingRule.getFusingName(), windowTime);
        if (failSize >= (long)fusingRule.getThreshold()) {
            return null;
        }
        return new FusingToken(fusingRule, windowTime, failSize);
    }

    public static void track(FusingToken token) throws BlockException {
        if (token == null) {
            return;
        }
        String fusingName = token.getFusingRule().getFusingName();
        long windowTime = token.getWindowTime();
        CycleCounterAdvisor.increment(fusingName, windowTime);
    }
}

