/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class StringListHelper {
    public static void write(OutputStream ostr, List<String> v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.size());
            for (String elem : v) {
                ostr.writeString(elem);
            }
        }
    }

    public static List<String> read(InputStream istr) {
        ArrayList<String> v = new ArrayList<String>();
        int len0 = istr.readAndCheckSeqSize(1);
        for (int i0 = 0; i0 < len0; ++i0) {
            String elem = istr.readString();
            v.add(elem);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<List<String>> v) {
        if (v != null && v.isPresent()) {
            StringListHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, List<String> v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            StringListHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<List<String>> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            List<String> v = StringListHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

