/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.rpc.netty;

import com.dtstep.lighthouse.common.entity.rpc.RpcRequest;
import com.dtstep.lighthouse.common.entity.rpc.RpcResponse;
import com.dtstep.lighthouse.common.rpc.netty.NettyClientHandler;
import com.dtstep.lighthouse.common.rpc.netty.RemoteProxy;
import com.dtstep.lighthouse.common.rpc.netty.RpcDecoder;
import com.dtstep.lighthouse.common.rpc.netty.RpcEncoder;
import com.dtstep.lighthouse.common.serializer.KryoSerializer;
import com.dtstep.lighthouse.common.util.IpUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.timeout.IdleStateHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientAdapter.class);
    private static final List<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
    private static ChannelPoolMap<InetSocketAddress, ChannelPool> poolMap;
    private static final int maxConnections = 10;
    private static final NettyClientHandler clientHandler;
    private static final NettyClientAdapter nettyClientAdapter;

    private NettyClientAdapter() {
    }

    public static NettyClientAdapter instance() {
        return nettyClientAdapter;
    }

    public void init(String locators) throws Exception {
        String[] locatorArr;
        for (String conf : locatorArr = locators.split(",")) {
            int port;
            String[] arr = conf.split(":");
            String ip = arr[0];
            InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, port = Integer.parseInt(arr[1]));
            if (addressList.contains(inetSocketAddress) || !IpUtils.checkIpPort(ip, port)) continue;
            addressList.add(inetSocketAddress);
        }
        this.connect();
    }

    public void connect() {
        NioEventLoopGroup group = new NioEventLoopGroup();
        final Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class);
        poolMap = new AbstractChannelPoolMap<InetSocketAddress, ChannelPool>(){

            @Override
            protected ChannelPool newPool(InetSocketAddress key) {
                FixedChannelPool channelPool = new FixedChannelPool(bootstrap.remoteAddress(key), new ChannelPoolHandler(){

                    @Override
                    public void channelReleased(Channel ch) throws Exception {
                        if (logger.isDebugEnabled()) {
                            logger.debug("channel released,id:" + ch.id());
                        }
                    }

                    @Override
                    public void channelAcquired(Channel ch) throws Exception {
                        if (logger.isDebugEnabled()) {
                            logger.debug("channel acquired,id:" + ch.id());
                        }
                    }

                    @Override
                    public void channelCreated(Channel ch) throws Exception {
                        if (logger.isInfoEnabled()) {
                            logger.info("Netty channel created,id:" + ch.id());
                        }
                        int fieldLength = 4;
                        ch.pipeline().addLast(new IdleStateHandler(0L, 30L, 0L, TimeUnit.SECONDS)).addLast(new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, fieldLength, 0, fieldLength)).addLast(new LengthFieldPrepender(fieldLength)).addLast("encoder", (ChannelHandler)new RpcEncoder(RpcRequest.class, new KryoSerializer())).addLast("decoder", (ChannelHandler)new RpcDecoder(RpcResponse.class, new KryoSerializer())).addLast(clientHandler);
                    }
                }, 10);
                channelPool.acquire().addListener(future -> {
                    if (future.isSuccess()) {
                        logger.info("Netty create channel success,id:{}", (Object)((Channel)future.getNow()).id());
                        Channel channel = (Channel)future.getNow();
                        channelPool.release(channel);
                    } else {
                        logger.info("Netty create channel failed,id:{}", (Object)((Channel)future.getNow()).id());
                    }
                });
                return channelPool;
            }
        };
    }

    public static ChannelPoolMap<InetSocketAddress, ChannelPool> getPoolMap() {
        return poolMap;
    }

    public <T> T create(Class<?> clazz) {
        Class<?>[] classArray;
        RemoteProxy proxy = new RemoteProxy(addressList, clazz);
        if (clazz.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        } else {
            classArray = clazz.getInterfaces();
        }
        Class<?>[] interfaces = classArray;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)proxy);
    }

    static {
        clientHandler = new NettyClientHandler();
        nettyClientAdapter = new NettyClientAdapter();
    }
}

