/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.serializer;

import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.TimeParam;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.serializer.Serializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KryoSerializer
implements Serializer {
    private static final ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(false);
        kryo.register(LocalDateTime.class);
        kryo.register(LimitValue.class);
        kryo.register(StatValue.class);
        kryo.register(StatVerifyEntity.class);
        kryo.register(GroupVerifyEntity.class);
        kryo.register(GroupStateEnum.class);
        kryo.register(TimeParam.class);
        return kryo;
    });

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> byte[] serialize(T obj) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output(byteArrayOutputStream);){
                Kryo kryo = kryoThreadLocal.get();
                kryo.writeObject(output, obj);
                output.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize object!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws Exception {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            T t;
            try (Input input = new Input(byteArrayInputStream);){
                Kryo kryo = kryoThreadLocal.get();
                t = kryo.readObject(input, clazz);
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize object!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> byte[] serializerList(List<T> list) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output(byteArrayOutputStream);){
                Kryo kryo = kryoThreadLocal.get();
                kryo.writeObject(output, list);
                output.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize list object!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> deserializeList(byte[] bytes, Class<T> clazz) throws Exception {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            List list;
            try (Input input = new Input(byteArrayInputStream);){
                Kryo kryo = kryoThreadLocal.get();
                list = kryo.readObject(input, ArrayList.class);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize list object!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> byte[] serializerMap(Map<K, V> map) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output(byteArrayOutputStream);){
                Kryo kryo = kryoThreadLocal.get();
                kryo.writeObject(output, map);
                output.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize map object!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> Map<K, V> deserializeMap(byte[] bytes, Class<? extends Map> clazz) throws Exception {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            Map map;
            try (Input input = new Input(byteArrayInputStream);){
                Kryo kryo = kryoThreadLocal.get();
                map = kryo.readObject(input, HashMap.class);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize list object!", e);
        }
    }
}

