/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import com.dtstep.lighthouse.common.modal.HttpRequestConfig;
import com.dtstep.lighthouse.common.modal.KeyValue;
import com.dtstep.lighthouse.common.modal.RequestBodyDTO;
import com.dtstep.lighthouse.common.util.DateUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;

public class OkHttpUtil {
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(false).build();
    private static final OkHttpClient retryClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    private static final Set<String> HOP_BY_HOP_HEADERS = Set.of("Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailer", "Transfer-Encoding", "Upgrade");

    public static String post(String url, String requestBody) throws IOException {
        MediaType mediaType = MediaType.get("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(requestBody, mediaType);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    public static String post(HttpUrl httpUrl, TreeMap<String, String> headers, RequestBody requestBody) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).method("POST", requestBody);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        Request request = requestBuilder.build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String request(HttpRequestConfig requestConfig) throws IOException {
        String method;
        Objects.requireNonNull(requestConfig.getUrl(), "URL must not be null");
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(requestConfig.getUrl())).newBuilder();
        if (requestConfig.getParams() != null) {
            for (KeyValue param : requestConfig.getParams()) {
                urlBuilder.addQueryParameter(param.getKey(), param.getValue());
            }
        }
        HttpUrl url = urlBuilder.build();
        RequestBody body = OkHttpUtil.buildRequestBody(requestConfig.getBody());
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (requestConfig.getHeaders() != null) {
            for (KeyValue keyValue : requestConfig.getHeaders()) {
                requestBuilder.addHeader(keyValue.getKey(), keyValue.getValue());
            }
        }
        switch (method = requestConfig.getMethod().toUpperCase()) {
            case "GET": {
                requestBuilder.get();
                break;
            }
            case "POST": {
                requestBuilder.post(body != null ? body : OkHttpUtil.emptyBody());
                break;
            }
            case "PUT": {
                requestBuilder.put(body != null ? body : OkHttpUtil.emptyBody());
                break;
            }
            case "DELETE": {
                requestBuilder.delete(body != null ? body : OkHttpUtil.emptyBody());
                break;
            }
            default: {
                requestBuilder.method(method, body != null ? body : OkHttpUtil.emptyBody());
            }
        }
        try (Response response = retryClient.newCall(requestBuilder.build()).execute();){
            if (!response.isSuccessful()) {
                String throwable = "ErrorCode:" + response.code() + ", Message:" + response.message() + ", URL:" + response.request().url() + ", Time:" + DateUtil.formatTimeStamp(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss") + ", ResponseBody:" + response.body().string();
                return throwable;
            }
            String string2 = response.body() != null ? response.body().string() : null;
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            return "Network error: Unknown host - " + requestConfig.getUrl();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return "Network error: Request timed out - " + requestConfig.getUrl();
        }
        catch (ConnectException connectException) {
            return "Network error: Connection refused - " + requestConfig.getUrl();
        }
        catch (Exception exception) {
            return "Network error: " + exception.getMessage();
        }
    }

    private static RequestBody buildRequestBody(RequestBodyDTO bodyDTO) {
        String type;
        if (bodyDTO == null || bodyDTO.getType() == null) {
            return null;
        }
        switch (type = bodyDTO.getType().toLowerCase()) {
            case "form-data": {
                if (bodyDTO.getFormData() == null) break;
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                for (KeyValue kv : bodyDTO.getFormData()) {
                    multipartBuilder.addFormDataPart(kv.getKey(), kv.getValue());
                }
                return multipartBuilder.build();
            }
            case "x-www-form-urlencoded": {
                if (bodyDTO.getUrlencodedData() == null) break;
                StringBuilder encoded = new StringBuilder();
                for (KeyValue kv : bodyDTO.getUrlencodedData()) {
                    if (encoded.length() > 0) {
                        encoded.append("&");
                    }
                    encoded.append(URLEncoder.encode(kv.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(kv.getValue(), StandardCharsets.UTF_8));
                }
                MediaType mediaType = MediaType.get("application/x-www-form-urlencoded; charset=utf-8");
                return RequestBody.create(encoded.toString(), mediaType);
            }
            case "json": {
                if (bodyDTO.getJson() == null) break;
                MediaType mediaType = MediaType.get("application/json; charset=utf-8");
                return RequestBody.create(bodyDTO.getJson().toString(), mediaType);
            }
            case "xml": {
                if (bodyDTO.getXml() == null) break;
                MediaType mediaType = MediaType.get("application/xml; charset=utf-8");
                return RequestBody.create(bodyDTO.getXml(), mediaType);
            }
            case "raw": {
                if (bodyDTO.getRaw() == null) break;
                MediaType mediaType = MediaType.get("text/plain; charset=utf-8");
                return RequestBody.create(bodyDTO.getRaw(), mediaType);
            }
        }
        return null;
    }

    public static Response forwardRequest(String targetUrl, String method, Map<String, String> headers, byte[] body) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(targetUrl);
        OkHttpUtil.setHttpMethod(requestBuilder, method, body, headers);
        if (headers != null) {
            headers.forEach((headerName, headerValue) -> {
                if (!OkHttpUtil.isHopByHopHeader(headerName) && headerValue != null) {
                    requestBuilder.addHeader((String)headerName, (String)headerValue);
                }
            });
        }
        Request request = requestBuilder.build();
        OkHttpClient executeClient = "GET".equalsIgnoreCase(method) ? retryClient : client;
        return executeClient.newCall(request).execute();
    }

    public static void forwardRequestAsync(String targetUrl, String method, Map<String, String> headers, byte[] body, Callback callback) {
        Request.Builder requestBuilder = new Request.Builder().url(targetUrl);
        OkHttpUtil.setHttpMethod(requestBuilder, method, body, headers);
        if (headers != null) {
            headers.forEach((headerName, headerValue) -> {
                if (!OkHttpUtil.isHopByHopHeader(headerName) && headerValue != null) {
                    requestBuilder.addHeader((String)headerName, (String)headerValue);
                }
            });
        }
        Request request = requestBuilder.build();
        client.newCall(request).enqueue(callback);
    }

    private static void setHttpMethod(Request.Builder requestBuilder, String method, byte[] body, Map<String, String> headers) {
        String contentType;
        String string = contentType = headers != null ? headers.get("Content-Type") : null;
        if ("GET".equalsIgnoreCase(method)) {
            requestBuilder.get();
        } else if ("POST".equalsIgnoreCase(method)) {
            RequestBody requestBody = OkHttpUtil.createRequestBody(body, contentType);
            requestBuilder.post(requestBody);
        } else if ("PUT".equalsIgnoreCase(method)) {
            RequestBody requestBody = OkHttpUtil.createRequestBody(body, contentType);
            requestBuilder.put(requestBody);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            if (body != null && body.length > 0) {
                RequestBody requestBody = OkHttpUtil.createRequestBody(body, contentType);
                requestBuilder.delete(requestBody);
            } else {
                requestBuilder.delete();
            }
        } else if ("PATCH".equalsIgnoreCase(method)) {
            RequestBody requestBody = OkHttpUtil.createRequestBody(body, contentType);
            requestBuilder.patch(requestBody);
        } else if ("HEAD".equalsIgnoreCase(method)) {
            requestBuilder.head();
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
    }

    private static RequestBody createRequestBody(byte[] body, String contentType) {
        if (body == null || body.length == 0) {
            return RequestBody.create(new byte[]{}, contentType != null ? MediaType.parse(contentType) : null);
        }
        MediaType mediaType = contentType != null ? MediaType.parse(contentType) : MediaType.parse("application/octet-stream");
        return RequestBody.create(body, mediaType);
    }

    private static boolean isHopByHopHeader(String headerName) {
        return headerName != null && HOP_BY_HOP_HEADERS.stream().anyMatch(h -> h.equalsIgnoreCase(headerName));
    }

    private static RequestBody emptyBody() {
        return RequestBody.create(new byte[0], null);
    }
}

