/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.ConnectionTimeoutException;
import com.zeroc.Ice.ContextHelper;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.FacetNotExistException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.ImplicitContextI;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.InvocationTimeoutException;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.RequestFailedException;
import com.zeroc.Ice.UnknownException;
import com.zeroc.Ice.UnknownLocalException;
import com.zeroc.Ice.UnknownReplyStatusException;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.CancellationHandler;
import com.zeroc.IceInternal.Holder;
import com.zeroc.IceInternal.ObserverHelper;
import com.zeroc.IceInternal.OutgoingAsyncBaseI;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBase;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RequestHandler;
import com.zeroc.IceInternal.RetryException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class ProxyOutgoingAsyncBaseI<T>
extends OutgoingAsyncBaseI<T>
implements ProxyOutgoingAsyncBase {
    protected final _ObjectPrxI _proxy;
    protected RequestHandler _handler;
    protected OperationMode _mode;
    protected int _proxyMode;
    private Future<?> _timerFuture;
    private int _cnt;
    private boolean _sent;
    private static final Map<String, String> _emptyContext = new HashMap<String, String>();

    public boolean isBatch() {
        return this._proxyMode == 2 || this._proxyMode == 4;
    }

    @Override
    public ObjectPrx getProxy() {
        return this._proxy;
    }

    @Override
    public boolean completed(InputStream is) {
        assert (this._proxy.ice_isTwoway());
        if (this._childObserver != null) {
            this._childObserver.reply(is.size() - 14 - 4);
            this._childObserver.detach();
            this._childObserver = null;
        }
        try {
            byte replyStatus = is.readByte();
            switch (replyStatus) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this._observer == null) break;
                    this._observer.userException();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    String facet;
                    Identity id = Identity.ice_read(is);
                    String[] facetPath = is.readStringSeq();
                    if (facetPath.length > 0) {
                        if (facetPath.length > 1) {
                            throw new MarshalException();
                        }
                        facet = facetPath[0];
                    } else {
                        facet = "";
                    }
                    String operation = is.readString();
                    RequestFailedException ex = null;
                    switch (replyStatus) {
                        case 2: {
                            ex = new ObjectNotExistException();
                            break;
                        }
                        case 3: {
                            ex = new FacetNotExistException();
                            break;
                        }
                        case 4: {
                            ex = new OperationNotExistException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ex.id = id;
                    ex.facet = facet;
                    ex.operation = operation;
                    throw ex;
                }
                case 5: 
                case 6: 
                case 7: {
                    String unknown = is.readString();
                    UnknownException ex = null;
                    switch (replyStatus) {
                        case 7: {
                            ex = new UnknownException();
                            break;
                        }
                        case 5: {
                            ex = new UnknownLocalException();
                            break;
                        }
                        case 6: {
                            ex = new UnknownUserException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ex.unknown = unknown;
                    throw ex;
                }
                default: {
                    throw new UnknownReplyStatusException();
                }
            }
            return this.finished(replyStatus == 0, true);
        }
        catch (Exception ex) {
            return this.completed(ex);
        }
    }

    @Override
    public boolean completed(Exception exc) {
        if (this._childObserver != null) {
            this._childObserver.failed(exc.ice_id());
            this._childObserver.detach();
            this._childObserver = null;
        }
        this._cachedConnection = null;
        if (this._proxy._getReference().getInvocationTimeout() == -2 && this._timerFuture != null) {
            this._timerFuture.cancel(false);
            this._timerFuture = null;
        }
        try {
            this._instance.retryQueue().add(this, this.handleException(exc));
            return false;
        }
        catch (Exception ex) {
            return this.finished(ex);
        }
    }

    @Override
    public void retryException(Exception ex) {
        block2: {
            try {
                this._proxy._updateRequestHandler(this._handler, null);
                this._instance.retryQueue().add(this, 0);
            }
            catch (Exception exc) {
                if (!this.completed(exc)) break block2;
                this.invokeCompletedAsync();
            }
        }
    }

    @Override
    public void retry() {
        this.invokeImpl(false);
    }

    @Override
    public void cancelable(CancellationHandler handler) {
        int timeout2;
        if (this._proxy._getReference().getInvocationTimeout() == -2 && this._cachedConnection != null && (timeout2 = this._cachedConnection.timeout()) > 0) {
            this._timerFuture = this._instance.timer().schedule(() -> this.cancel(new ConnectionTimeoutException()), (long)timeout2, TimeUnit.MILLISECONDS);
        }
        super.cancelable(handler);
    }

    @Override
    public void abort(Exception ex) {
        assert (this._childObserver == null);
        if (this.finished(ex)) {
            this.invokeCompletedAsync();
        } else if (ex instanceof CommunicatorDestroyedException) {
            throw ex;
        }
    }

    protected ProxyOutgoingAsyncBaseI(_ObjectPrxI prx, String op) {
        super(prx.ice_getCommunicator(), prx._getReference().getInstance(), op);
        this._proxy = prx;
        this._mode = OperationMode.Normal;
        this._cnt = 0;
        this._sent = false;
        this._proxyMode = this._proxy._getReference().getMode();
    }

    protected ProxyOutgoingAsyncBaseI(_ObjectPrxI prx, String op, OutputStream os) {
        super(prx.ice_getCommunicator(), prx._getReference().getInstance(), op, os);
        this._proxy = prx;
        this._mode = OperationMode.Normal;
        this._cnt = 0;
        this._sent = false;
        this._proxyMode = this._proxy._getReference().getMode();
    }

    /*
     * Unable to fully structure code
     */
    protected void invokeImpl(boolean userThread) {
        try {
            if (userThread) {
                invocationTimeout = this._proxy._getReference().getInvocationTimeout();
                if (invocationTimeout > 0) {
                    this._timerFuture = this._instance.timer().schedule((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$invokeImpl$1(), ()V)((ProxyOutgoingAsyncBaseI)this), (long)invocationTimeout, TimeUnit.MILLISECONDS);
                }
            } else if (this._observer != null) {
                this._observer.retried();
            }
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    this._sent = false;
                    this._handler = null;
                    this._handler = this._proxy._getRequestHandler();
                    status = this._handler.sendAsyncRequest(this);
                    if ((status & 1) > 0) {
                        if (userThread) {
                            this._sentSynchronously = true;
                            if ((status & 2) > 0) {
                                this.invokeSent();
                            }
                        } else if ((status & 2) > 0) {
                            this.invokeSentAsync();
                        }
                    }
                    return;
                }
                catch (RetryException ex) {
                    this._proxy._updateRequestHandler(this._handler, null);
                }
                catch (Exception ex) {
                    if (this._childObserver != null) {
                        this._childObserver.failed(ex.ice_id());
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    if ((interval = this.handleException(ex)) > 0) {
                        this._instance.retryQueue().add(this, interval);
                        return;
                    }
                    if (this._observer == null) ** GOTO lbl-1000
                    this._observer.retried();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            if (userThread) {
                throw ex;
            }
            if (this.finished(ex)) {
                this.invokeCompletedAsync();
            }
            return;
        }
        ** GOTO lbl-1000
    }

    @Override
    protected boolean sent(boolean done) {
        this._sent = true;
        if (done && this._timerFuture != null) {
            this._timerFuture.cancel(false);
            this._timerFuture = null;
        }
        return super.sent(done);
    }

    @Override
    protected boolean finished(Exception ex) {
        if (this._timerFuture != null) {
            this._timerFuture.cancel(false);
            this._timerFuture = null;
        }
        return super.finished(ex);
    }

    @Override
    protected boolean finished(boolean ok, boolean invoke2) {
        if (this._timerFuture != null) {
            this._timerFuture.cancel(false);
            this._timerFuture = null;
        }
        return super.finished(ok, invoke2);
    }

    protected int handleException(Exception exc) {
        Holder<Integer> interval = new Holder<Integer>();
        this._cnt = this._proxy._handleException(exc, this._handler, this._mode, this._sent, interval, this._cnt);
        return (Integer)interval.value;
    }

    protected void prepare(Map<String, String> ctx) {
        Protocol.checkSupportedProtocol(Protocol.getCompatibleProtocol(this._proxy._getReference().getProtocol()));
        this._observer = ObserverHelper.get(this._proxy, this._operation, ctx == null ? _emptyContext : ctx);
        switch (this._proxyMode) {
            case 0: 
            case 1: 
            case 3: {
                this._os.writeBlob(Protocol.requestHdr);
                break;
            }
            case 2: 
            case 4: {
                this._proxy._getBatchRequestQueue().prepareBatchRequest(this._os);
            }
        }
        Reference ref = this._proxy._getReference();
        ref.getIdentity().ice_writeMembers(this._os);
        String facet = ref.getFacet();
        if (facet == null || facet.length() == 0) {
            this._os.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{facet};
            this._os.writeStringSeq(facetPath);
        }
        this._os.writeString(this._operation);
        this._os.writeByte((byte)this._mode.value());
        if (ctx != ObjectPrx.noExplicitContext) {
            ContextHelper.write(this._os, ctx);
        } else {
            ImplicitContextI implicitContext = ref.getInstance().getImplicitContext();
            Map<String, String> prxContext = ref.getContext();
            if (implicitContext == null) {
                ContextHelper.write(this._os, prxContext);
            } else {
                implicitContext.write(prxContext, this._os);
            }
        }
    }

    private /* synthetic */ void lambda$invokeImpl$1() {
        this.cancel(new InvocationTimeoutException());
    }
}

