/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.NoEndpointException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.ProtocolVersion;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.BatchRequestQueue;
import com.zeroc.IceInternal.DefaultsAndOverrides;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.FixedReference;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.LocatorInfo;
import com.zeroc.IceInternal.OpaqueEndpointI;
import com.zeroc.IceInternal.OutgoingConnectionFactory;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RequestHandler;
import com.zeroc.IceInternal.RouterInfo;
import com.zeroc.IceInternal.ThreadPool;
import com.zeroc.IceInternal.TraceLevels;
import com.zeroc.IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;

public class RoutableReference
extends Reference {
    private static EndpointComparator _preferNonSecureEndpointComparator = new EndpointComparator(false);
    private static EndpointComparator _preferSecureEndpointComparator = new EndpointComparator(true);
    private static EndpointI[] _emptyEndpoints = new EndpointI[0];
    private EndpointI[] _endpoints;
    private String _adapterId;
    private LocatorInfo _locatorInfo;
    private RouterInfo _routerInfo;
    private boolean _collocationOptimized;
    private boolean _cacheConnection;
    private boolean _preferSecure;
    private EndpointSelectionType _endpointSelection;
    private int _locatorCacheTimeout;
    private boolean _overrideTimeout;
    private int _timeout;
    private String _connectionId = "";

    @Override
    public final EndpointI[] getEndpoints() {
        return this._endpoints;
    }

    @Override
    public final String getAdapterId() {
        return this._adapterId;
    }

    @Override
    public final LocatorInfo getLocatorInfo() {
        return this._locatorInfo;
    }

    @Override
    public final RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    @Override
    public final boolean getCollocationOptimized() {
        return this._collocationOptimized;
    }

    @Override
    public final boolean getCacheConnection() {
        return this._cacheConnection;
    }

    @Override
    public final boolean getPreferSecure() {
        return this._preferSecure;
    }

    @Override
    public final EndpointSelectionType getEndpointSelection() {
        return this._endpointSelection;
    }

    @Override
    public final int getLocatorCacheTimeout() {
        return this._locatorCacheTimeout;
    }

    @Override
    public final String getConnectionId() {
        return this._connectionId;
    }

    @Override
    public OptionalInt getTimeout() {
        return this._overrideTimeout ? OptionalInt.of(this._timeout) : OptionalInt.empty();
    }

    @Override
    public final ThreadPool getThreadPool() {
        return this.getInstance().clientThreadPool();
    }

    @Override
    public final ConnectionI getConnection() {
        return null;
    }

    @Override
    public Reference changeEncoding(EncodingVersion newEncoding) {
        LocatorInfo locInfo;
        RoutableReference r = (RoutableReference)super.changeEncoding(newEncoding);
        if (r != this && (locInfo = r._locatorInfo) != null && !locInfo.getLocator().ice_getEncodingVersion().equals(newEncoding)) {
            r._locatorInfo = this.getInstance().locatorManager().get(locInfo.getLocator().ice_encodingVersion(newEncoding));
        }
        return r;
    }

    @Override
    public Reference changeCompress(boolean newCompress) {
        RoutableReference r = (RoutableReference)super.changeCompress(newCompress);
        if (r != this && this._endpoints.length > 0) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].compress(newCompress);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    @Override
    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        if (Arrays.equals(newEndpoints, this._endpoints)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._endpoints = newEndpoints;
        r._adapterId = "";
        r.applyOverrides(r._endpoints);
        return r;
    }

    @Override
    public Reference changeAdapterId(String newAdapterId) {
        if (this._adapterId.equals(newAdapterId)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._adapterId = newAdapterId;
        r._endpoints = _emptyEndpoints;
        return r;
    }

    @Override
    public Reference changeLocator(LocatorPrx newLocator) {
        LocatorInfo newLocatorInfo = this.getInstance().locatorManager().get(newLocator);
        if (newLocatorInfo != null && this._locatorInfo != null && newLocatorInfo.equals(this._locatorInfo)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._locatorInfo = newLocatorInfo;
        return r;
    }

    @Override
    public Reference changeRouter(RouterPrx newRouter) {
        RouterInfo newRouterInfo = this.getInstance().routerManager().get(newRouter);
        if (newRouterInfo != null && this._routerInfo != null && newRouterInfo.equals(this._routerInfo)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._routerInfo = newRouterInfo;
        return r;
    }

    @Override
    public Reference changeCollocationOptimized(boolean newCollocationOptimized) {
        if (newCollocationOptimized == this._collocationOptimized) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._collocationOptimized = newCollocationOptimized;
        return r;
    }

    @Override
    public final Reference changeCacheConnection(boolean newCache) {
        if (newCache == this._cacheConnection) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._cacheConnection = newCache;
        return r;
    }

    @Override
    public Reference changePreferSecure(boolean newPreferSecure) {
        if (newPreferSecure == this._preferSecure) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._preferSecure = newPreferSecure;
        return r;
    }

    @Override
    public final Reference changeEndpointSelection(EndpointSelectionType newType) {
        if (newType == this._endpointSelection) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._endpointSelection = newType;
        return r;
    }

    @Override
    public Reference changeLocatorCacheTimeout(int newTimeout) {
        if (this._locatorCacheTimeout == newTimeout) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._locatorCacheTimeout = newTimeout;
        return r;
    }

    @Override
    public Reference changeTimeout(int newTimeout) {
        if (this._overrideTimeout && this._timeout == newTimeout) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._timeout = newTimeout;
        r._overrideTimeout = true;
        if (this._endpoints.length > 0) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].timeout(newTimeout);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    @Override
    public Reference changeConnectionId(String id) {
        if (this._connectionId.equals(id)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._connectionId = id;
        if (this._endpoints.length > 0) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].connectionId(id);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    @Override
    public Reference changeConnection(ConnectionI connection) {
        return new FixedReference(this.getInstance(), this.getCommunicator(), this.getIdentity(), this.getFacet(), this.getMode(), this.getSecure(), this.getProtocol(), this.getEncoding(), connection, this.getInvocationTimeout(), this.getContext(), this.getCompress());
    }

    @Override
    public boolean isIndirect() {
        return this._endpoints.length == 0;
    }

    @Override
    public boolean isWellKnown() {
        return this._endpoints.length == 0 && this._adapterId.length() == 0;
    }

    @Override
    public void streamWrite(OutputStream s) throws MarshalException {
        super.streamWrite(s);
        s.writeSize(this._endpoints.length);
        if (this._endpoints.length > 0) {
            assert (this._adapterId.length() == 0);
            for (EndpointI endpoint : this._endpoints) {
                s.writeShort(endpoint.type());
                endpoint.streamWrite(s);
            }
        } else {
            s.writeString(this._adapterId);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(128);
        s.append(super.toString());
        if (this._endpoints.length > 0) {
            for (EndpointI endpoint : this._endpoints) {
                String endp = endpoint.toString();
                if (endp == null || endp.length() <= 0) continue;
                s.append(':');
                s.append(endp);
            }
        } else if (this._adapterId.length() > 0) {
            s.append(" @ ");
            String a = StringUtil.escapeString(this._adapterId, null, this.getInstance().toStringMode());
            if (StringUtil.findFirstOf(a, " :@") != -1) {
                s.append('\"');
                s.append(a);
                s.append('\"');
            } else {
                s.append(a);
            }
        }
        return s.toString();
    }

    @Override
    public Map<String, String> toProperty(String prefix) {
        _ObjectPrxI h;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(prefix, this.toString());
        properties.put(prefix + ".CollocationOptimized", this._collocationOptimized ? "1" : "0");
        properties.put(prefix + ".ConnectionCached", this._cacheConnection ? "1" : "0");
        properties.put(prefix + ".PreferSecure", this._preferSecure ? "1" : "0");
        properties.put(prefix + ".EndpointSelection", this._endpointSelection == EndpointSelectionType.Random ? "Random" : "Ordered");
        StringBuffer s = new StringBuffer();
        s.append(this.getInvocationTimeout());
        properties.put(prefix + ".InvocationTimeout", s.toString());
        s = new StringBuffer();
        s.append(this._locatorCacheTimeout);
        properties.put(prefix + ".LocatorCacheTimeout", s.toString());
        if (this._routerInfo != null) {
            h = (_ObjectPrxI)((Object)this._routerInfo.getRouter());
            Map<String, String> routerProperties = h._getReference().toProperty(prefix + ".Router");
            for (Map.Entry<String, String> p : routerProperties.entrySet()) {
                properties.put(p.getKey(), p.getValue());
            }
        }
        if (this._locatorInfo != null) {
            h = (_ObjectPrxI)((Object)this._locatorInfo.getLocator());
            Map<String, String> locatorProperties = h._getReference().toProperty(prefix + ".Locator");
            for (Map.Entry<String, String> p : locatorProperties.entrySet()) {
                properties.put(p.getKey(), p.getValue());
            }
        }
        return properties;
    }

    @Override
    public synchronized int hashCode() {
        if (!this._hashInitialized) {
            super.hashCode();
            this._hashValue = HashUtil.hashAdd(this._hashValue, this._adapterId);
        }
        return this._hashValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RoutableReference)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RoutableReference rhs = (RoutableReference)obj;
        if (this._locatorInfo == null ? rhs._locatorInfo != null : !this._locatorInfo.equals(rhs._locatorInfo)) {
            return false;
        }
        if (this._routerInfo == null ? rhs._routerInfo != null : !this._routerInfo.equals(rhs._routerInfo)) {
            return false;
        }
        if (this._collocationOptimized != rhs._collocationOptimized) {
            return false;
        }
        if (this._cacheConnection != rhs._cacheConnection) {
            return false;
        }
        if (this._preferSecure != rhs._preferSecure) {
            return false;
        }
        if (this._endpointSelection != rhs._endpointSelection) {
            return false;
        }
        if (this._locatorCacheTimeout != rhs._locatorCacheTimeout) {
            return false;
        }
        if (!this._connectionId.equals(rhs._connectionId)) {
            return false;
        }
        if (this._overrideTimeout != rhs._overrideTimeout) {
            return false;
        }
        if (this._overrideTimeout && this._timeout != rhs._timeout) {
            return false;
        }
        if (!Arrays.equals(this._endpoints, rhs._endpoints)) {
            return false;
        }
        return this._adapterId.equals(rhs._adapterId);
    }

    @Override
    public RequestHandler getRequestHandler(_ObjectPrxI proxy) {
        return this.getInstance().requestHandlerFactory().getRequestHandler(this, proxy);
    }

    @Override
    public BatchRequestQueue getBatchRequestQueue() {
        return new BatchRequestQueue(this.getInstance(), this.getMode() == 4);
    }

    public void getConnection(final Reference.GetConnectionCallback callback) {
        if (this._routerInfo != null) {
            this._routerInfo.getClientEndpoints(new RouterInfo.GetClientEndpointsCallback(){

                @Override
                public void setEndpoints(EndpointI[] endpts) {
                    if (endpts.length > 0) {
                        RoutableReference.this.applyOverrides(endpts);
                        RoutableReference.this.createConnection(endpts, callback);
                    } else {
                        RoutableReference.this.getConnectionNoRouterInfo(callback);
                    }
                }

                @Override
                public void setException(LocalException ex) {
                    callback.setException(ex);
                }
            });
        } else {
            this.getConnectionNoRouterInfo(callback);
        }
    }

    public void getConnectionNoRouterInfo(final Reference.GetConnectionCallback callback) {
        if (this._endpoints.length > 0) {
            this.createConnection(this._endpoints, callback);
            return;
        }
        final RoutableReference self = this;
        if (this._locatorInfo != null) {
            this._locatorInfo.getEndpoints(this, this._locatorCacheTimeout, new LocatorInfo.GetEndpointsCallback(){

                @Override
                public void setEndpoints(EndpointI[] endpoints, final boolean cached) {
                    if (endpoints.length == 0) {
                        callback.setException(new NoEndpointException(self.toString()));
                        return;
                    }
                    RoutableReference.this.applyOverrides(endpoints);
                    RoutableReference.this.createConnection(endpoints, new Reference.GetConnectionCallback(){

                        @Override
                        public void setConnection(ConnectionI connection, boolean compress) {
                            callback.setConnection(connection, compress);
                        }

                        @Override
                        public void setException(LocalException exc) {
                            try {
                                throw exc;
                            }
                            catch (NoEndpointException ex) {
                                callback.setException(ex);
                            }
                            catch (LocalException ex) {
                                assert (RoutableReference.this._locatorInfo != null);
                                RoutableReference.this._locatorInfo.clearCache(self);
                                if (cached) {
                                    TraceLevels traceLvls = RoutableReference.this.getInstance().traceLevels();
                                    if (traceLvls.retry >= 2) {
                                        String s = "connection to cached endpoints failed\nremoving endpoints from cache and trying again\n" + ex;
                                        RoutableReference.this.getInstance().initializationData().logger.trace(traceLvls.retryCat, s);
                                    }
                                    RoutableReference.this.getConnectionNoRouterInfo(callback);
                                    return;
                                }
                                callback.setException(ex);
                            }
                        }
                    });
                }

                @Override
                public void setException(LocalException ex) {
                    callback.setException(ex);
                }
            });
        } else {
            callback.setException(new NoEndpointException(this.toString()));
        }
    }

    protected RoutableReference(Instance instance, Communicator communicator, Identity identity, String facet, int mode, boolean secure, ProtocolVersion protocol, EncodingVersion encoding, EndpointI[] endpoints, String adapterId, LocatorInfo locatorInfo, RouterInfo routerInfo, boolean collocationOptimized, boolean cacheConnection, boolean prefereSecure, EndpointSelectionType endpointSelection, int locatorCacheTimeout, int invocationTimeout, Map<String, String> context) {
        super(instance, communicator, identity, facet, mode, secure, protocol, encoding, invocationTimeout, context);
        this._endpoints = endpoints;
        this._adapterId = adapterId;
        this._locatorInfo = locatorInfo;
        this._routerInfo = routerInfo;
        this._collocationOptimized = collocationOptimized;
        this._cacheConnection = cacheConnection;
        this._preferSecure = prefereSecure;
        this._endpointSelection = endpointSelection;
        this._locatorCacheTimeout = locatorCacheTimeout;
        this._overrideTimeout = false;
        this._timeout = -1;
        if (this._endpoints == null) {
            this._endpoints = _emptyEndpoints;
        }
        if (this._adapterId == null) {
            this._adapterId = "";
        }
        assert (this._adapterId.length() == 0 || this._endpoints.length == 0);
    }

    protected void applyOverrides(EndpointI[] endpts) {
        for (int i = 0; i < endpts.length; ++i) {
            endpts[i] = endpts[i].connectionId(this._connectionId);
            if (this._overrideCompress) {
                endpts[i] = endpts[i].compress(this._compress);
            }
            if (!this._overrideTimeout) continue;
            endpts[i] = endpts[i].timeout(this._timeout);
        }
    }

    private EndpointI[] filterEndpoints(EndpointI[] allEndpoints) {
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (EndpointI endpoint : allEndpoints) {
            if (endpoint instanceof OpaqueEndpointI) continue;
            endpoints.add(endpoint);
        }
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    EndpointI endpoint = (EndpointI)i.next();
                    if (!endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
            case 3: 
            case 4: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    EndpointI endpoint = (EndpointI)i.next();
                    if (endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
        }
        switch (this.getEndpointSelection()) {
            case Random: {
                Collections.shuffle(endpoints);
                break;
            }
            case Ordered: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        DefaultsAndOverrides overrides = this.getInstance().defaultsAndOverrides();
        if (overrides.overrideSecure ? overrides.overrideSecureValue : this.getSecure()) {
            Iterator i = endpoints.iterator();
            while (i.hasNext()) {
                EndpointI endpoint = (EndpointI)i.next();
                if (endpoint.secure()) continue;
                i.remove();
            }
        } else if (this.getPreferSecure()) {
            Collections.sort(endpoints, _preferSecureEndpointComparator);
        } else {
            Collections.sort(endpoints, _preferNonSecureEndpointComparator);
        }
        return endpoints.toArray(new EndpointI[endpoints.size()]);
    }

    protected void createConnection(EndpointI[] allEndpoints, final Reference.GetConnectionCallback callback) {
        final EndpointI[] endpoints = this.filterEndpoints(allEndpoints);
        if (endpoints.length == 0) {
            callback.setException(new NoEndpointException(this.toString()));
            return;
        }
        final OutgoingConnectionFactory factory2 = this.getInstance().outgoingConnectionFactory();
        if (this.getCacheConnection() || endpoints.length == 1) {
            factory2.create(endpoints, false, this.getEndpointSelection(), new OutgoingConnectionFactory.CreateConnectionCallback(){

                @Override
                public void setConnection(ConnectionI connection, boolean compress) {
                    if (RoutableReference.this._routerInfo != null && RoutableReference.this._routerInfo.getAdapter() != null) {
                        connection.setAdapter(RoutableReference.this._routerInfo.getAdapter());
                    }
                    callback.setConnection(connection, compress);
                }

                @Override
                public void setException(LocalException ex) {
                    callback.setException(ex);
                }
            });
        } else {
            factory2.create(new EndpointI[]{endpoints[0]}, true, this.getEndpointSelection(), new OutgoingConnectionFactory.CreateConnectionCallback(){
                private int _i = 0;
                private LocalException _exception = null;

                @Override
                public void setConnection(ConnectionI connection, boolean compress) {
                    if (RoutableReference.this._routerInfo != null && RoutableReference.this._routerInfo.getAdapter() != null) {
                        connection.setAdapter(RoutableReference.this._routerInfo.getAdapter());
                    }
                    callback.setConnection(connection, compress);
                }

                @Override
                public void setException(LocalException ex) {
                    if (this._exception == null) {
                        this._exception = ex;
                    }
                    if (++this._i == endpoints.length) {
                        callback.setException(this._exception);
                        return;
                    }
                    boolean more = this._i != endpoints.length - 1;
                    EndpointI[] endpoint = new EndpointI[]{endpoints[this._i]};
                    factory2.create(endpoint, more, RoutableReference.this.getEndpointSelection(), this);
                }
            });
        }
    }

    static class EndpointComparator
    implements Comparator<EndpointI> {
        private boolean _preferSecure;

        EndpointComparator(boolean preferSecure) {
            this._preferSecure = preferSecure;
        }

        @Override
        public int compare(EndpointI le, EndpointI re) {
            boolean ls = le.secure();
            boolean rs = re.secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                if (this._preferSecure) {
                    return 1;
                }
                return -1;
            }
            if (this._preferSecure) {
                return -1;
            }
            return 1;
        }
    }
}

