/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.standalone.executive;

import com.dtstep.lighthouse.standalone.rpc.NettyServerHandler;
import com.dtstep.lighthouse.standalone.rpc.ServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightStandaloneService {
    private static final Logger logger = LoggerFactory.getLogger(LightStandaloneService.class);
    private static final int port = 4061;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        EpollEventLoopGroup workerGroup;
        EpollEventLoopGroup bossGroup;
        if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup();
            workerGroup = new EpollEventLoopGroup();
        } else if (KQueue.isAvailable()) {
            bossGroup = new KQueueEventLoopGroup();
            workerGroup = new KQueueEventLoopGroup();
        } else {
            bossGroup = new NioEventLoopGroup();
            workerGroup = new NioEventLoopGroup();
        }
        NettyServerHandler.register();
        try {
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)server.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : (KQueue.isAvailable() ? KQueueServerSocketChannel.class : NioServerSocketChannel.class))).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(EpollChannelOption.SO_REUSEPORT, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new ServerInitializer()).childOption(ChannelOption.SO_SNDBUF, (Object)0xA00000).childOption(ChannelOption.SO_RCVBUF, (Object)0xA00000);
            ChannelFuture future = server.bind(4061).sync();
            logger.info("ldp standalone rpc service start,listen:{}", (Object)4061);
            future.channel().closeFuture().sync();
        }
        catch (Exception ex) {
            logger.error("ldp standalone rpc service startup exception!", (Throwable)ex);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

